package simplelogin.ui.test;

import simplelogin.domain.AuthResults;
import simplelogin.ui.LoginPresenter;
import junit.framework.TestCase;

public class TestLoginPresenter extends TestCase {

	private LoginPresenter fixture;
	private StubLoginView stubView;
	private StubAuthService stubService;

	protected void setUp() throws Exception {
		stubView = new StubLoginView();
		stubService = new StubAuthService(); 
		fixture = new LoginPresenter(stubView, stubService);
	}

	protected void tearDown() throws Exception {
	}
	
	public void testInitSetOkDisabledAndNextDisabled() {
		//operate
		fixture.initView();
		
		//assert
		assertFalse(stubView.loginEnabled);
		assertFalse(stubView.nextEnabled);
	}
	
	public void testUpdateViewSetLoginEnabledJustWhenBothUsernameAndPasswordAreSet() {
		//init
		fixture.initView();
		
		//operate
		checkButtons("", "", false, false);
		checkButtons("a", "", false, false);
		checkButtons("a", "a", true, false);
	}
	
	public void testLoginValidCredentialSetNextEnabledndLoginDisabled() {
		//init
		fixture.initView();
		
		//expect
		stubService.setupAuthenticate(AuthResults.OK);
		
		//operate
		stubView.username = "aa";
		stubView.password = "aa";
		fixture.login();
		
		//assert
		assertTrue(stubView.nextEnabled);
		assertFalse(stubView.loginEnabled);
	}
	
	private void checkButtons(String username, String password, boolean ok, boolean next) {
		stubView.username = username;
		stubView.password = password;

		//operate
		fixture.updateView();
		
		//assert
		assertEquals(ok, stubView.loginEnabled);
		assertEquals(next, stubView.nextEnabled);
	}

}
