package simplelogin.ui;

import simplelogin.domain.AuthResult;
import simplelogin.domain.AuthResults;
import simplelogin.domain.AuthService;

public class LoginPresenter {

	private LoginView view;
	private AuthService service;
	private boolean authenticated = false;

	public LoginPresenter(LoginView view, AuthService service) {
		this.view = view;
		this.service = service;
	}

	public void login() {
		AuthResult result = service.authenticate(view.getUsername(), view.getPassword());
		authenticated = result.equals(AuthResults.OK);
		updateView();
	}

	public void initView() {
		view.setLoginEnabled(false);
		view.setNextEnabled(false);
	}

	public void updateView() {
		view.setNextEnabled(authenticated);
		if(authenticated) {
			view.setLoginEnabled(false);
			return;
		}
		
		view.setLoginEnabled(view.getUsername() != "" && view.getPassword() != "");
	}

}
