package simplelogin.domain.test;

import simplelogin.domain.AuthResult;
import simplelogin.domain.AuthResults;
import simplelogin.domain.AuthService;
import simplelogin.domain.User;
import simplelogin.domain.UserDataAccess;
import junit.framework.TestCase;
import static org.easymock.EasyMock.*;

public class TestAuthService extends TestCase {
	
	private AuthService fixture;
	private UserDataAccess mockUserDA;
	private User dummyUser;
	
	private final String validUsername = "USERNAME";
	private final String validPassword = "PASSWORD";

	protected void setUp() throws Exception {
		mockUserDA = createMock(UserDataAccess.class);
		dummyUser = new User(validUsername, validPassword);
		fixture = new AuthService(mockUserDA);
	}

	protected void tearDown() throws Exception {
		verify(mockUserDA);
	}
	
	public void testAuthenticateValidCredentials() {
		checkAuthenticate(validUsername, validPassword, AuthResults.OK, dummyUser);
	}

	public void testAuthenticateUserNotFound() {
		checkAuthenticate("", "", AuthResults.INVALID_USERNAME, null);
	}
	
	public void testAuthenticateWrongPassword() {
		checkAuthenticate(validUsername, "", AuthResults.WRONG_PASSWORD, dummyUser);
	}
	
	private void checkAuthenticate(String username, String password, AuthResult expectedResult, User dummyUser) {
		//init
		AuthResult result;
		
		//expect
		expect(mockUserDA.getUserByUsername(username))
			.andReturn(dummyUser)
			.once();
		replay(mockUserDA);
		
		//operate
		result = fixture.authenticate(username, password);
		
		//assert
		assertEquals(expectedResult, result);
	}

}
