package simplelogin.domain;

public class AuthService {
	private UserDataAccess dataAccess;

	public AuthService(UserDataAccess userDA) {
		this.dataAccess = userDA;
	}

	public AuthResult authenticate(String username, String password) {
		User aUser = dataAccess.getUserByUsername(username);
		
		if(aUser == null ) {
			return AuthResults.INVALID_USERNAME;
		}

		if( ! aUser.hasPassword(password) ) {
			return AuthResults.WRONG_PASSWORD;
		}
		
		return AuthResults.OK;
	}
}
