package simplelogin.acceptancetests;

import java.util.ArrayList;
import java.util.Collection;

import simplelogin.domain.User;
import fit.RowFixture;

public class UserListFixture extends RowFixture {

	@Override
	public Class getTargetClass() {
		return UserAdapter.class;
	}

	@Override
	public Object[] query() throws Exception {
		return createAdapotersFrom(UserAccountsFixture.userDA.getAllUsers());
	}

	private Object[] createAdapotersFrom(Collection<User> allUsers) {
		ArrayList<UserAdapter> users = new ArrayList<UserAdapter>();
		
		for(User item : allUsers) {
			users.add(new UserAdapter(item.getUsername()));
		}
		
		return users.toArray();
	}

}
