package simplelogin.acceptancetests;

import simplelogin.domain.AuthService;
import simplelogin.ui.LoginPresenter;
import simplelogin.ui.test.StubLoginView;
import fit.ActionFixture;

public class LoginPageFixture extends ActionFixture {

	private static LoginPresenter presenter;
	private static StubLoginView view;
		
	static {
		view = new StubLoginView();
		presenter = new LoginPresenter(view, new AuthService(UserAccountsFixture.userDA));
		presenter.initView();		
	}
	
	public String loginButtonIs() {
		return toEnabledString(view.loginEnabled);
	}

	public String nextButtonIs() {
		return toEnabledString(view.nextEnabled);
	}
	
	public void username(String username) {
		view.username = username;
		presenter.updateView();
	}
	
	public void password(String password) {
		view.password = password;
		presenter.updateView();
	}
	
	public void loginButton() {
		presenter.login();
	}

	private String toEnabledString(boolean value) {
		return value ? "enabled" : "disabled";
	}
	
}
