package simplelogin.acceptancetests;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import simplelogin.domain.User;
import simplelogin.domain.UserDataAccess;

public class InMemoryUserDA implements UserDataAccess {

	private Map<String, User> users = new HashMap<String, User>();
	
	public User getUserByUsername(String username) {
		return users.get(username);
	}

	public void add(User user) {
		users.put(user.getUsername(), user);
	}

	public Collection<User> getAllUsers() {
		return users.values();
	}

}
