/*
 * Decompiled with CFR 0.152.
 */
package test.fitlibrary.valueAdapter;

import fit.Parse;
import fitlibrary.DoFixture;
import fitlibrary.FitLibraryFixture;
import fitlibrary.parse.Cell;
import fitlibrary.ref.EntityReference;
import fitlibrary.valueAdapter.ValueAdapter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestReferenceAdapter
extends TestCase {
    private List list;
    public MyClass aProp;
    static /* synthetic */ Class class$test$fitlibrary$valueAdapter$TestReferenceAdapter$MyClass;

    public void setUp() {
        this.list = new ArrayList();
        this.list.add(new MyClass(1));
        this.list.add(new MyClass(2));
        this.list.add(new MyClass(3));
        this.aProp = (MyClass)this.list.get(1);
    }

    public void testParseAlone() throws Exception {
        ValueAdapter adapter = ValueAdapter.on((FitLibraryFixture)new MyDoFixture(), class$test$fitlibrary$valueAdapter$TestReferenceAdapter$MyClass == null ? (class$test$fitlibrary$valueAdapter$TestReferenceAdapter$MyClass = TestReferenceAdapter.class$("test.fitlibrary.valueAdapter.TestReferenceAdapter$MyClass")) : class$test$fitlibrary$valueAdapter$TestReferenceAdapter$MyClass);
        Object first = this.list.get(0);
        this.checkReference(adapter, "the", first);
        this.checkReference(adapter, "the first", first);
        this.checkReference(adapter, "the first MyClass", first);
        this.checkReference(adapter, "the first myClass", first);
        this.checkReference(adapter, "1st", first);
        Assert.assertEquals((String)"the second MyClass", (String)adapter.toString(this.list.get(1)));
        Assert.assertEquals((String)"the third MyClass", (String)adapter.toString(this.list.get(2)));
    }

    private void checkReference(ValueAdapter adapter, String text, Object element) throws Exception {
        Parse parse = new Cell((String)text).parse;
        Assert.assertEquals((Object)element, (Object)adapter.parse(new Cell(parse)));
        Assert.assertTrue((boolean)adapter.matches(new Cell(parse), element));
        Assert.assertEquals((String)"the first MyClass", (String)adapter.toString(element));
    }

    public void testParseFails() throws Exception {
        ValueAdapter adapter = ValueAdapter.on((FitLibraryFixture)new MyDoFixture(), class$test$fitlibrary$valueAdapter$TestReferenceAdapter$MyClass == null ? (class$test$fitlibrary$valueAdapter$TestReferenceAdapter$MyClass = TestReferenceAdapter.class$("test.fitlibrary.valueAdapter.TestReferenceAdapter$MyClass")) : class$test$fitlibrary$valueAdapter$TestReferenceAdapter$MyClass);
        this.checkReferenceFails(adapter, "th");
        this.checkReferenceFails(adapter, "the forst");
        this.checkReferenceFails(adapter, "the first My Class");
        this.checkReferenceFails(adapter, "the first myClass.");
        this.checkReferenceFails(adapter, "2nd");
    }

    private void checkReferenceFails(ValueAdapter adapter, String text) {
        try {
            Cell cell = new Cell(text);
            adapter.parse(cell);
            Assert.fail((String)("Should throw and exception with '" + text + "'"));
        }
        catch (Exception e) {}
    }

    public void testParseWithMethod() throws Exception {
        Method method = ((Object)((Object)this)).getClass().getMethod("aMethod", new Class[0]);
        ValueAdapter adapter = ValueAdapter.on(new MyDoFixture(), class$test$fitlibrary$valueAdapter$TestReferenceAdapter$MyClass == null ? (class$test$fitlibrary$valueAdapter$TestReferenceAdapter$MyClass = TestReferenceAdapter.class$("test.fitlibrary.valueAdapter.TestReferenceAdapter$MyClass")) : class$test$fitlibrary$valueAdapter$TestReferenceAdapter$MyClass, method, null, true);
        adapter.setTarget((Object)this);
        Assert.assertEquals(this.list.get(2), (Object)adapter.get());
        Assert.assertEquals((String)"the third MyClass", (String)adapter.getString());
    }

    public MyClass aMethod() {
        return (MyClass)this.list.get(2);
    }

    public void testParseWithField() throws Exception {
        Field field = ((Object)((Object)this)).getClass().getField("aProp");
        ValueAdapter adapter = ValueAdapter.on(new MyDoFixture(), class$test$fitlibrary$valueAdapter$TestReferenceAdapter$MyClass == null ? (class$test$fitlibrary$valueAdapter$TestReferenceAdapter$MyClass = TestReferenceAdapter.class$("test.fitlibrary.valueAdapter.TestReferenceAdapter$MyClass")) : class$test$fitlibrary$valueAdapter$TestReferenceAdapter$MyClass, null, field, true);
        adapter.setTarget((Object)this);
        Assert.assertEquals(this.list.get(1), (Object)adapter.get());
        Assert.assertEquals((String)"the second MyClass", (String)adapter.getString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class MyClass {
        private int value;

        public MyClass(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return "MyClass-" + this.value;
        }
    }

    public class MyDoFixture
    extends DoFixture {
        public MyClass findMyClass(int index) {
            return (MyClass)TestReferenceAdapter.this.list.get(index);
        }

        public MyClass findMyClass(String text) {
            if ("1st".equals(text)) {
                return this.findMyClass(0);
            }
            throw new RuntimeException("Unavailable: MyClass from '" + text + "'");
        }

        public String showMyClass(MyClass object) {
            return EntityReference.reference(object, TestReferenceAdapter.this.list);
        }
    }
}

