/*
 * Decompiled with CFR 0.152.
 */
package test.fitlibrary.valueAdapter;

import fit.Parse;
import fitlibrary.DoFixture;
import fitlibrary.FitLibraryFixture;
import fitlibrary.parse.Cell;
import fitlibrary.valueAdapter.ValueAdapter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestCollectionValueAdapter
extends TestCase {
    Collection list;
    public Collection aProp;

    public void setUp() {
        this.list = new ArrayList();
        this.list.add("1");
        this.list.add("2");
        this.list.add("3");
        this.aProp = new ArrayList();
        this.aProp.add("4");
        this.aProp.add("5");
        this.aProp.add("6");
    }

    public void testAdapterAlone() throws Exception {
        ValueAdapter adapter = ValueAdapter.on((FitLibraryFixture)new DoFixture(), this.list.getClass());
        String cellText = "1, 2, 3";
        Parse parse = new Cell((String)cellText).parse;
        Assert.assertEquals((Object)this.list, (Object)adapter.parse(new Cell(parse)));
        Assert.assertTrue((boolean)adapter.matches(new Cell(parse), this.list));
        Assert.assertEquals((String)cellText, (String)adapter.toString(this.list));
    }

    public void testAdapterWithMethod() throws Exception {
        Method method = ((Object)((Object)this)).getClass().getMethod("aMethod", new Class[0]);
        ValueAdapter adapter = ValueAdapter.on(new DoFixture(), this.list.getClass(), method, null, true);
        adapter.setTarget((Object)this);
        Assert.assertEquals((Object)this.aProp, (Object)adapter.get());
        Assert.assertEquals((String)"4, 5, 6", (String)adapter.getString());
    }

    public Collection aMethod() {
        return this.aProp;
    }

    public void testAdapterWithField() throws Exception {
        Field field = ((Object)((Object)this)).getClass().getField("aProp");
        ValueAdapter adapter = ValueAdapter.on(new DoFixture(), this.list.getClass(), null, field, true);
        adapter.setTarget((Object)this);
        Assert.assertEquals((Object)this.aProp, (Object)adapter.get());
        Assert.assertEquals((String)"4, 5, 6", (String)adapter.getString());
    }
}

