/*
 * Decompiled with CFR 0.152.
 */
package test.fitlibrary.valueAdapter;

import fit.Parse;
import fitlibrary.DoFixture;
import fitlibrary.FitLibraryFixture;
import fitlibrary.parse.Cell;
import fitlibrary.valueAdapter.ValueAdapter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestArrayValueAdapter
extends TestCase {
    public int[] aProp = new int[]{5, 6, 7};

    public void testAdapterAlone() throws Exception {
        int[] ints = new int[]{1, 2, 3};
        ValueAdapter adapter = ValueAdapter.on((FitLibraryFixture)new DoFixture(), ints.getClass());
        String cellText = "1, 2, 3";
        Parse parse = new Cell((String)cellText).parse;
        int[] expectedResult = new int[]{1, 2, 3};
        this.assertArrayEquals(expectedResult, (int[])adapter.parse(new Cell(parse)));
        Assert.assertTrue((boolean)adapter.matches(new Cell(parse), expectedResult));
        Assert.assertEquals((String)cellText, (String)adapter.toString(expectedResult));
    }

    private void assertArrayEquals(int[] expectedResult, int[] actual) {
        Assert.assertEquals((int)expectedResult.length, (int)actual.length);
        int i = 0;
        while (i < actual.length) {
            Assert.assertEquals((int)expectedResult[i], (int)actual[i]);
            ++i;
        }
    }

    public void testAdapterWithMethod() throws Exception {
        int[] ints = new int[]{4, 5, 6};
        Method method = ((Object)((Object)this)).getClass().getMethod("aMethod", new Class[0]);
        ValueAdapter adapter = ValueAdapter.on(null, ints.getClass(), method, null, true);
        adapter.setTarget((Object)this);
        Object actual = adapter.get();
        Assert.assertEquals(ints.getClass(), actual.getClass());
        this.assertArrayEquals(ints, (int[])actual);
        Assert.assertEquals((String)"4, 5, 6", (String)adapter.getString());
    }

    public int[] aMethod() {
        return new int[]{4, 5, 6};
    }

    public void testAdapterWithField() throws Exception {
        int[] ints = new int[]{4, 5, 6};
        Field field = ((Object)((Object)this)).getClass().getField("aProp");
        ValueAdapter adapter = ValueAdapter.on(null, ints.getClass(), null, field, true);
        adapter.setTarget((Object)this);
        this.assertArrayEquals(new int[]{5, 6, 7}, (int[])adapter.get());
        Assert.assertEquals((String)"5, 6, 7", (String)adapter.toString(new int[]{5, 6, 7}));
        Assert.assertEquals((String)"5, 6, 7", (String)adapter.getString());
    }

    public void testAdapterWithReferenceElements() throws Exception {
        MyClass[] them = new MyClass[]{new MyClass(1), new MyClass(2), new MyClass(3)};
        MyDoFixture fixture = new MyDoFixture(them);
        ValueAdapter adapter = ValueAdapter.on((FitLibraryFixture)fixture, them.getClass());
        String cellText = "the first, the second, the third";
        Cell parse = new Cell(cellText);
        this.assertArrayEquals(them, (MyClass[])adapter.parse(parse));
        Assert.assertEquals((String)cellText, (String)adapter.toString(them));
    }

    private void assertArrayEquals(MyClass[] expectedResult, MyClass[] actual) {
        Assert.assertEquals((int)expectedResult.length, (int)actual.length);
        int i = 0;
        while (i < actual.length) {
            Assert.assertEquals((Object)expectedResult[i], (Object)actual[i]);
            ++i;
        }
    }

    public static class MyClass {
        private int value;

        public MyClass(int value) {
            this.value = value;
        }
    }

    public static class MyDoFixture
    extends DoFixture {
        private MyClass[] them;

        public MyDoFixture(MyClass[] them) {
            this.them = them;
        }

        public MyClass findMyClass(int index) {
            return this.them[index];
        }

        public String showMyClass(MyClass object) {
            MyClass[] myClasses = this.them;
            return this.show(object, myClasses);
        }

        private String show(MyClass object, MyClass[] myClasses) {
            if (myClasses[0] == object) {
                return "the first";
            }
            if (myClasses[1] == object) {
                return "the second";
            }
            if (myClasses[2] == object) {
                return "the third";
            }
            return "unknown";
        }
    }
}

