/*
 * Decompiled with CFR 0.152.
 */
package test.fitlibrary;

import fit.Parse;
import fitlibrary.parse.ParseUtility;
import java.text.ParseException;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestParseUtility
extends TestCase {
    private static final String html = "<html><title>table</title><body>t1<table><tr><td>Test</td></tr></table>t2t3<table><tr><td>Test</td></tr></table>t4</body></html>";
    private static String setUpHtml = "<html><title>setup</title><body>s1<table><tr><td>SetUp</td></tr></table>s2s3<table><tr><td>SetUp</td></tr></table>s4</body></html>";
    private static String tearDownHtml = "<html><title>teardown</title><body>front<table><tr><td>TearDown</td></tr></table>backT3<table><tr><td>TearDown</td></tr></table>T4</body></html>";
    private Parse tables;
    private Parse setUp;
    private Parse tearDown;

    public void setUp() throws ParseException {
        this.tables = new Parse(html);
        this.setUp = new Parse(setUpHtml);
        this.tearDown = new Parse(tearDownHtml);
    }

    public void testAppend() {
        String expected = "<html><title>setup</title><body>s1<table><tr><td>SetUp</td></tr></table>s2s3<table><tr><td>SetUp</td></tr></table>s4<br>front<table><tr><td>TearDown</td></tr></table>backT3<table><tr><td>TearDown</td></tr></table>T4</body></html>";
        ParseUtility.append(this.setUp, this.tearDown);
        this.assertEquals(expected, this.setUp);
    }

    public void testAppendNull() {
        ParseUtility.append(this.setUp, null);
        this.assertEquals(setUpHtml, this.setUp);
    }

    public void testAppendSetUp() {
        String expected = "<html><title>table</title><body>s1<table><tr><td>SetUp</td></tr></table>s2s3<table><tr><td>SetUp</td></tr></table>s4<br>t1<table><tr><td>Test</td></tr></table>t2t3<table><tr><td>Test</td></tr></table>t4</body></html>";
        ParseUtility.appendToSetUp(this.setUp, this.tables);
        this.assertEquals(expected, this.setUp);
    }

    public void testAppendSetUpWithNull() {
        ParseUtility.appendToSetUp(this.setUp, null);
        this.assertEquals(setUpHtml, this.setUp);
    }

    public void testAppendAll() {
        String expected = "<html><title>table</title><body>s1<table><tr><td>SetUp</td></tr></table>s2s3<table><tr><td>SetUp</td></tr></table>s4<br>t1<table><tr><td>Test</td></tr></table>t2t3<table><tr><td>Test</td></tr></table>t4<br>front<table><tr><td>TearDown</td></tr></table>backT3<table><tr><td>TearDown</td></tr></table>T4</body></html>";
        ParseUtility.append(this.tables, this.tearDown);
        ParseUtility.appendToSetUp(this.setUp, this.tables);
        this.assertEquals(expected, this.setUp);
    }

    private void assertEquals(String expected, Parse tables2) {
        Assert.assertEquals((String)expected, (String)ParseUtility.toString(tables2));
    }

    public void testFixHeader() {
        String result = ParseUtility.removeHeader(this.tables);
        Assert.assertEquals((String)"<html><title>table</title><body>", (String)result);
        this.assertEquals("t1<table><tr><td>Test</td></tr></table>t2t3<table><tr><td>Test</td></tr></table>t4</body></html>", this.tables);
    }

    public void testInitialTable() {
        this.assertEquals(html, this.tables);
    }

    public void testChangeHeader() {
        ParseUtility.changeHeader(this.tables, "<html><title>new</title><body><hr>");
        this.assertEquals("<html><title>new</title><body><hr>t1<table><tr><td>Test</td></tr></table>t2t3<table><tr><td>Test</td></tr></table>t4</body></html>", this.tables);
    }

    public void testCompleteTrailerThatIsComplete() {
        ParseUtility.completeTrailer(this.tables);
        this.assertEquals(html, this.tables);
    }

    public void testCompleteTrailerThatIsInComplete() {
        this.tables.last().trailer = "JUNK";
        ParseUtility.completeTrailer(this.tables);
        this.assertEquals("<html><title>table</title><body>t1<table><tr><td>Test</td></tr></table>t2t3<table><tr><td>Test</td></tr></table>JUNK\n</body></html>\n", this.tables);
    }

    public void testFixTrailersNone() throws ParseException {
        String setUpHtml2 = "<html><title>setup</title><body><table><tr><td>SetUp</td></tr></table></body></html>";
        Parse setUp2 = new Parse(setUpHtml2);
        ParseUtility.fixTrailers(setUp2, this.tables);
        this.assertEquals("<html><title>setup</title><body><table><tr><td>SetUp</td></tr></table>", setUp2);
        this.assertEquals(html, this.tables);
    }

    public void testFixTrailers() {
        ParseUtility.removeHeader(this.tables);
        ParseUtility.fixTrailers(this.setUp, this.tables);
        this.assertEquals("<html><title>setup</title><body>s1<table><tr><td>SetUp</td></tr></table>s2s3<table><tr><td>SetUp</td></tr></table>", this.setUp);
        this.assertEquals("s4<br>t1<table><tr><td>Test</td></tr></table>t2t3<table><tr><td>Test</td></tr></table>t4</body></html>", this.tables);
    }
}

