/*
 * Decompiled with CFR 0.152.
 */
package test.fitlibrary;

import fit.Counts;
import fit.Parse;
import fit.exception.FitParseException;
import fitlibrary.DoFixture;
import fitlibrary.parse.Cell;
import fitlibrary.parse.Row;
import fitlibrary.parse.Table;
import fitlibrary.parse.Tables;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestParseTables
extends TestCase {
    private Tables tables;
    private Counts counts;

    public void setUp() throws FitParseException {
        this.tables = new Tables(new Parse("<table><tr><td>1</td></tr><tr><td>2</td><td>3</td></tr></table>\n<table><tr><td>1</td></tr><tr><td>2</td><td>3</td></tr></table>\n<table><tr><td>1</td></tr><tr><td>2</td><td>3</td></tr></table>\n"));
        this.counts = new Counts();
    }

    public void testTables() {
        Assert.assertEquals((int)3, (int)this.tables.size());
    }

    public void testTable0() {
        Table table = this.tables.table(0);
        Assert.assertEquals((int)2, (int)table.size());
        Assert.assertTrue((!table.rowExists(-1) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)table.rowExists(0));
        Assert.assertTrue((boolean)table.rowExists(1));
        Assert.assertTrue((!table.rowExists(2) ? 1 : 0) != 0);
        Assert.assertEquals((Object)table.row(1), (Object)table.lastRow());
        try {
            table.row(2);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {}
    }

    public void testTable0Right() {
        Table table0 = this.tables.table(0);
        table0.right(this.counts);
        Assert.assertTrue((boolean)table0.row(0).isRight());
        Assert.assertEquals((String)"1 right, 0 wrong, 0 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testTable0Wrong() {
        Table table0 = this.tables.table(0);
        table0.wrong(this.counts);
        Assert.assertTrue((boolean)table0.row(0).isWrong());
        Assert.assertEquals((String)"0 right, 1 wrong, 0 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testTable0Missing() {
        Table table0 = this.tables.table(0);
        table0.missing(this.counts);
        Assert.assertTrue((boolean)table0.row(0).cell(0).isWrong());
        Assert.assertEquals((String)"1 missing", (String)table0.row(0).text(0));
        Assert.assertEquals((String)"0 right, 1 wrong, 0 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testTable0Ignored() {
        Table table0 = this.tables.table(0);
        table0.ignore(this.counts);
        Assert.assertTrue((boolean)table0.row(0).isIgnored());
        Assert.assertEquals((String)"0 right, 0 wrong, 1 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testTable0Exception() {
        Table table0 = this.tables.table(0);
        DoFixture doFixture = new DoFixture();
        doFixture.counts = this.counts;
        table0.exception(doFixture, new RuntimeException("Forced"));
        Assert.assertTrue((boolean)table0.row(0).cell(0).hasException());
        Assert.assertTrue((boolean)table0.row(0).text(0).startsWith("1java.lang.RuntimeException: Forced"));
        Assert.assertEquals((String)"0 right, 0 wrong, 0 ignored, 1 exceptions", (String)this.counts.toString());
    }

    public void testRow0() {
        Row row = this.getRow(0, 0);
        Assert.assertEquals((int)1, (int)row.size());
        Assert.assertTrue((!row.cellExists(-1) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)row.cellExists(0));
        Assert.assertTrue((!row.cellExists(1) ? 1 : 0) != 0);
        try {
            row.cell(1);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            // empty catch block
        }
        Assert.assertEquals((String)"1", (String)row.text(0));
    }

    public void testRow0Right() {
        Row row0 = this.getRow(0, 0);
        row0.right(this.counts);
        Assert.assertTrue((boolean)row0.isRight());
        Assert.assertEquals((String)"1 right, 0 wrong, 0 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testRow0Wrong() {
        Row row0 = this.getRow(0, 0);
        row0.wrong(this.counts);
        Assert.assertTrue((boolean)row0.isWrong());
        Assert.assertEquals((String)"0 right, 1 wrong, 0 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testRow0Missing() {
        Row row0 = this.getRow(0, 0);
        row0.missing(this.counts);
        Assert.assertTrue((boolean)row0.cell(0).isWrong());
        Assert.assertEquals((String)"1 missing", (String)row0.text(0));
        Assert.assertEquals((String)"0 right, 1 wrong, 0 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testRow0Ignored() {
        Row row0 = this.getRow(0, 0);
        row0.ignore(this.counts);
        Assert.assertTrue((boolean)row0.isIgnored());
        Assert.assertEquals((String)"0 right, 0 wrong, 1 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testRow0Exception() {
        Row row0 = this.getRow(0, 0);
        DoFixture doFixture = new DoFixture();
        doFixture.counts = this.counts;
        row0.exception(doFixture, new RuntimeException("Forced"));
        Assert.assertTrue((boolean)row0.cell(0).hasException());
        Assert.assertTrue((boolean)row0.text(0).startsWith("1java.lang.RuntimeException: Forced"));
        Assert.assertEquals((String)"0 right, 0 wrong, 0 ignored, 1 exceptions", (String)this.counts.toString());
    }

    public void testCell0Text() {
        Assert.assertEquals((String)"1", (String)this.getCell(0, 0, 0).text());
        Assert.assertEquals((String)"0 right, 0 wrong, 0 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testCell0Right() {
        Cell cell0 = this.getCell(0, 0, 0);
        cell0.right(this.counts);
        Assert.assertTrue((boolean)cell0.isRight());
        Assert.assertEquals((String)"1 right, 0 wrong, 0 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testCell0Wrong() {
        Cell cell0 = this.getCell(0, 0, 0);
        cell0.wrong(this.counts);
        Assert.assertTrue((boolean)cell0.isWrong());
        Assert.assertEquals((String)"0 right, 1 wrong, 0 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testCell0Missing() {
        Cell cell0 = this.getCell(0, 0, 0);
        cell0.missing(this.counts);
        Assert.assertTrue((boolean)cell0.isWrong());
        Assert.assertEquals((String)"1 missing", (String)cell0.text());
        Assert.assertEquals((String)"0 right, 1 wrong, 0 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testCell0Ignored() {
        Cell cell0 = this.getCell(0, 0, 0);
        cell0.ignore(this.counts);
        Assert.assertTrue((boolean)cell0.isIgnored());
        Assert.assertEquals((String)"0 right, 0 wrong, 1 ignored, 0 exceptions", (String)this.counts.toString());
    }

    public void testCell0Exception() {
        Cell cell0 = this.getCell(0, 0, 0);
        DoFixture doFixture = new DoFixture();
        doFixture.counts = this.counts;
        cell0.exception(doFixture, new RuntimeException("Forced"));
        Assert.assertTrue((boolean)cell0.hasException());
        Assert.assertTrue((boolean)cell0.text().startsWith("1java.lang.RuntimeException: Forced"));
        Assert.assertEquals((String)"0 right, 0 wrong, 0 ignored, 1 exceptions", (String)this.counts.toString());
    }

    private Cell getCell(int tableNo, int rowNo, int cellNo) {
        return this.getRow(tableNo, rowNo).cell(cellNo);
    }

    private Row getRow(int tableNo, int rowNo) {
        return this.tables.table(tableNo).row(rowNo);
    }
}

