/*
 * Decompiled with CFR 0.152.
 */
package test.fitlibrary;

import fitlibrary.graphic.ObjectDotGraphic;
import java.awt.Point;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestObjectDotGraphic
extends TestCase {
    public void testPoint() {
        this.assertDot("digraph G {\nn0 [label = \"java.awt.Point[x=0,y=0]\"];\n}\n", new Point());
    }

    public void testMyPoint() {
        this.assertDot("digraph G {\nn0 [label = \"fitlibrary.test.TestObjectDotGraphic$MyPoint\"];\nn1 [label = \"0\"];\nn0 -> n1 [label=\"x\"];\nn0 -> n1 [label=\"y\"];\n}\n", new MyPoint());
    }

    public void testNested() {
        this.assertDot("digraph G {\nn0 [label = \"fitlibrary.test.TestObjectDotGraphic$MyRectangle\"];\nn1 [label = \"fitlibrary.test.TestObjectDotGraphic$MyPoint\"];\nn0 -> n1 [label=\"pt1\"];\nn2 [label = \"java.awt.Point[x=1,y=2]\"];\nn0 -> n2 [label=\"pt2\"];\nn3 [label = \"0\"];\nn1 -> n3 [label=\"x\"];\nn1 -> n3 [label=\"y\"];\n}\n", new MyRectangle());
    }

    private void assertDot(String expected, Object object) {
        Assert.assertEquals((Object)expected, (Object)new ObjectDotGraphic(object).getDot());
    }

    private static class MyRectangle {
        MyPoint pt1 = new MyPoint();
        Point pt2 = new Point(1, 2);

        private MyRectangle() {
        }

        public MyPoint getPt1() {
            return this.pt1;
        }

        public Point getPt2() {
            return this.pt2;
        }
    }

    private static class MyPoint
    extends Point {
        private MyPoint() {
        }
    }
}

