/*
 * Decompiled with CFR 0.152.
 */
package test.fitlibrary;

import fitlibrary.tree.ListTree;
import fitlibrary.tree.Tree;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestListTree
extends TestCase {
    private Tree topTree;
    private Tree tree;
    private Tree toplessTree;

    public void setUp() {
        this.topTree = new ListTree("top");
        this.tree = new ListTree("tree", new Tree[]{new ListTree("a"), new ListTree("b", new Tree[]{new ListTree("c")})});
        this.toplessTree = new ListTree("", new Tree[]{new ListTree("a"), new ListTree("b")});
    }

    public void testEqualsSameOne() {
        this.treesEqual(this.topTree, this.topTree);
    }

    public void testEqualsSimilarOne() {
        this.treesEqual(this.topTree, new ListTree("top"));
    }

    public void testNotEqualsSimilarOne() {
        this.treesUnEqual(this.topTree, new ListTree("bottom"));
    }

    public void testTopToString() {
        Assert.assertEquals((String)"top", (String)this.topTree.toString());
    }

    public void testToplessTreeToString() {
        Assert.assertEquals((String)"<ul><li>a</li><li>b</li></ul>", (String)this.toplessTree.toString());
    }

    public void testEqualsSameTree() {
        this.treesEqual(this.tree, this.tree);
    }

    public void testEqualsSimilarTree() {
        ListTree tree2 = new ListTree("tree", new Tree[]{new ListTree("a"), new ListTree("b", new Tree[]{new ListTree("c")})});
        this.treesEqual(this.tree, tree2);
    }

    public void testNotEqualsTop() {
        this.treesUnEqual(this.tree, this.topTree);
        this.treesUnEqual(this.topTree, this.toplessTree);
    }

    public void testNotEqualsSimilarShapedTree() {
        ListTree tree2 = new ListTree("tree", new Tree[]{new ListTree("a"), new ListTree("b", new Tree[]{new ListTree("C")})});
        this.treesUnEqual(this.tree, tree2);
    }

    public void testNotEqualsDifferentShapedTree() {
        ListTree tree2 = new ListTree("tree", new Tree[]{new ListTree("a", new Tree[]{new ListTree("c")}), new ListTree("b")});
        this.treesUnEqual(this.tree, tree2);
        this.treesUnEqual(this.tree, this.toplessTree);
    }

    public void testTreeToString() {
        Assert.assertEquals((String)"tree<ul><li>a</li><li>b<ul><li>c</li></ul></li></ul>", (String)this.tree.toString());
    }

    public void testParseTop() {
        Assert.assertEquals((Object)this.topTree, (Object)ListTree.parse("top"));
    }

    public void testParseTree1() {
        Assert.assertEquals((String)"tree<ul><li>a</li></ul>", (String)ListTree.parse("tree<ul><li>a</li></ul>").toString());
    }

    public void testParseTree() {
        this.assertParsed("tree<ul><li>a</li><li>b<ul><li>c</li></ul></li></ul>");
    }

    public void testParseTreeWithblanks() {
        this.assertParsed("tree<ul><li>a</li><li>b<ul><li>c</li></ul></li></ul>");
    }

    public void testParseToplessTree() {
        this.assertParsed("<ul><li>a</li><li>b<ul><li>c</li></ul></li></ul>");
    }

    public void testParseTags0() {
        this.assertParsed("<i>a</i>");
    }

    public void testParseSpace() {
        Assert.assertEquals((String)"a", (String)ListTree.parse("<i>a  </i>").text());
    }

    public void testParseTags1() {
        this.assertParsed("tree<ul><li><i>a</i></li></ul>");
    }

    public void testParseTags2() {
        this.assertParsed("tree<ul><li>a<i>b</i><b>c</b></li></ul>");
    }

    public void testEqualsIgnoringWhiteSpace() {
        this.treesEqual("tree<ul>\r\t\t  <li>a</li> \n<li>b<ul>   </ul>\n  </li>\n\t\n</ul>", "tree<ul><li>a</li><li>b<ul></ul></li></ul>");
    }

    public void testEqualsIgnoringWhiteSpaceInBoth() {
        this.treesEqual("tree<ul>\r\t\t  <li>a</li> \n<li>b<ul>   </ul>\n  </li>\n\t\n</ul>", "tree<ul> <li>a</li>\n\n<li>b<ul>\r\n</ul>\n\n\n</li></ul>");
    }

    public void testEqualsSimilarWithTags() {
        this.treesEqual(this.topTree, new ListTree("<i>top</i>"));
    }

    public void testTopText() {
        Assert.assertEquals((String)"top", (String)new ListTree("top").text());
    }

    public void testToplessTreeText() {
        Assert.assertEquals((String)"<ul><li>a</li><li>b</li></ul>", (String)this.toplessTree.text());
    }

    public void testTopTextWithTags() {
        Assert.assertEquals((String)"top", (String)new ListTree("<i><b>top</b></i>").text());
    }

    public void testTreeText() {
        Assert.assertEquals((String)"tree<ul><li>a</li><li>b<ul><li>c</li></ul></li></ul>", (String)this.tree.text());
    }

    public void testTreeTextWithTags() {
        String s = "tree<ul><li>a<i>b</i><b>c</b></li></ul>";
        Assert.assertEquals((String)"tree<ul><li>abc</li></ul>", (String)ListTree.parse(s).text());
    }

    public void testParseTreeNoCloseLi() {
        try {
            ListTree.parse("tree<ul><li>a<li>b<ul><li>c</ul></ul>");
            Assert.fail((String)"Doesn't handle lists with </li> missing.");
        }
        catch (RuntimeException e) {}
    }

    private void assertParsed(String s) {
        Assert.assertEquals((String)s, (String)ListTree.parse(s).toString());
    }

    private void treesEqual(String tree1, String tree2) {
        this.treesEqual(ListTree.parse(tree1), ListTree.parse(tree2));
    }

    private void treesEqual(Tree t1, Tree t2) {
        Assert.assertTrue((boolean)t1.equals(t2));
        Assert.assertTrue((boolean)t2.equals(t1));
        Assert.assertTrue((boolean)ListTree.equals(t1, t2));
        Assert.assertTrue((boolean)ListTree.equals(t2, t1));
    }

    private void treesUnEqual(Tree t1, Tree t2) {
        Assert.assertFalse((boolean)t1.equals(t2));
        Assert.assertFalse((boolean)t2.equals(t1));
        Assert.assertFalse((boolean)ListTree.equals(t1, t2));
        Assert.assertFalse((boolean)ListTree.equals(t2, t1));
    }
}

