/*
 * Decompiled with CFR 0.152.
 */
package test.fitlibrary;

import fitlibrary.ExtendedCamelCase;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestExtendedCamelCase
extends TestCase {
    public void testJustCamel() {
        this.check("two words", "twoWords");
        this.check("three wee words", "threeWeeWords");
    }

    public void testExtendedCamel() {
        this.check("\" hi \"", "quoteHiQuote");
        this.check("!#$%age", "bangHashDollarPercentAge");
        this.check("&'()*", "ampersandSingleQuoteLeftParenthesisRightParenthesisStar");
        this.check("+,-./:", "plusCommaMinusDotSlashColon");
        this.check(";=?", "semicolonEqualsQuestion");
        this.check("@[]\\", "atLeftSquareBracketRightSquareBracketBackslash");
        this.check("^`{}~", "caretBackquoteLeftBraceRightBraceTilde");
        this.check("cost $", "costDollar");
        this.check("cost$", "costDollar");
        this.check("!", "bang");
        this.check("!!", "bangBang");
        this.check("meet @", "meetAt");
        this.check("rick@mugridge.com", "rickAtMugridgeDotCom");
        this.check("", "blank");
    }

    public void testNewlineSeparator() {
        this.check("two\nwords", "twoWords");
        this.check("two\r\nwords", "twoWords");
        this.check("two \nwords", "twoWords");
        this.check("two \r\nwords", "twoWords");
    }

    public void testLeadingDigit() {
        this.check("2 words", "twoWords");
    }

    public void testLeadingCapital() {
        this.check("Two words", "twoWords");
    }

    public void testJavaKeyword() {
        this.check("static", "static_");
        this.check("return", "return_");
        this.check("null", "null_");
    }

    public void testUnicode() {
        this.check("\u216c", "u216C");
        this.check("\u216d\ufffe", "u216DuFFFE");
        this.check("\uffff", "uFFFF");
        this.check("Ab", "ab");
    }

    private void check(String in, String out) {
        Assert.assertEquals((String)out, (String)ExtendedCamelCase.camel(in));
    }
}

