/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.valueAdapter;

import fit.TypeAdapter;
import fit.exception.FitFailureException;
import fitlibrary.FitLibraryFixture;
import fitlibrary.closure.MethodClosure;
import fitlibrary.log.Logging;
import fitlibrary.parse.Cell;
import fitlibrary.ref.EntityReference;
import fitlibrary.valueAdapter.SimpleValueAdapter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ReferenceAdapter
extends SimpleValueAdapter {
    private FitLibraryFixture fixture;
    private MethodClosure findIntMethod;
    private MethodClosure findStringMethod;
    private MethodClosure showMethod;
    private EntityReference referenceParser;
    private String findExceptionMessage;
    private String showExceptionMethod;
    static /* synthetic */ Class class$java$lang$String;

    public ReferenceAdapter(TypeAdapter typeAdapter, FitLibraryFixture fixture, Method method, Field field, Class type) {
        super(typeAdapter, fixture, method, field, type);
        this.fixture = fixture;
        String className = Logging.simpleClassName(typeAdapter.type);
        this.referenceParser = EntityReference.create(className.toLowerCase());
        this.getReflectiveMethods(fixture, className);
    }

    private void getReflectiveMethods(FitLibraryFixture fixture, String className) {
        Class[] intArg = new Class[]{Integer.TYPE};
        Class[] stringArg = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ReferenceAdapter.class$("java.lang.String")) : class$java$lang$String};
        Class[] showArg = new Class[]{this.typeAdapter.type};
        String findName = "find" + className;
        String showName = "show" + className;
        this.findExceptionMessage = "Missing method: (1) Value object: public static " + className + " parse(String s) { } in class " + className + " OR (2) Entity, in the fixture class: public " + className + " " + findName;
        this.showExceptionMethod = "Missing method: public Object " + showName + "(" + className + " arg) { }";
        this.findIntMethod = fixture.findEntityMethod(findName, intArg);
        this.findStringMethod = fixture.findEntityMethod(findName, stringArg);
        this.showMethod = fixture.findEntityMethod(showName, showArg);
    }

    public Object parse(Cell cell) throws Exception {
        String text = cell.text();
        Logging.log(this, "parse(" + text + ")");
        if (this.findIntMethod != null) {
            int index = 0;
            try {
                index = this.referenceParser.getIndex(text);
            }
            catch (FitFailureException e) {
                return this.callFindStringMethod(text, true);
            }
            return this.findIntMethod.invoke(new Integer[]{new Integer(index)});
        }
        return this.callFindStringMethod(text, false);
    }

    private Object callFindStringMethod(String text, boolean findIntFailed) throws Exception {
        if (this.findStringMethod != null) {
            return this.findStringMethod.invoke(new String[]{text});
        }
        if (findIntFailed) {
            throw new FitFailureException(this.findExceptionMessage + "(String text) {");
        }
        throw new FitFailureException(this.findExceptionMessage + "(int index) {");
    }

    public String toString(Object result) throws Exception {
        Logging.log(this, "toString(" + result + ")");
        Object[] args = new Object[]{result};
        if (this.showMethod != null) {
            return this.showMethod.invoke(args).toString();
        }
        throw new FitFailureException(this.showExceptionMethod);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

