/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.valueAdapter;

import fit.Parse;
import fit.exception.FitFailureException;
import fitlibrary.parse.Cell;
import fitlibrary.valueAdapter.ValueAdapter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

public abstract class MetaValueAdapter
extends ValueAdapter {
    private Class type;
    private Method method;
    private Field field;
    private Object target;

    protected MetaValueAdapter(Class type, Method method, Field field) {
        this.type = type;
        this.method = method;
        this.field = field;
    }

    protected Object callReflectively(String methodName, Object[] args, Class[] argTypes, Object object) {
        try {
            Method reflectiveMethod = this.type.getMethod(methodName, argTypes);
            return reflectiveMethod.invoke(object, args);
        }
        catch (SecurityException e) {
            this.error(methodName, argTypes, e);
        }
        catch (NoSuchMethodException e) {
            this.error(methodName, argTypes, e);
        }
        catch (IllegalArgumentException e) {
            this.error(methodName, argTypes, e);
        }
        catch (IllegalAccessException e) {
            this.error(methodName, argTypes, e);
        }
        catch (InvocationTargetException e) {
            this.error(methodName, argTypes, e.getTargetException());
        }
        return null;
    }

    private void error(String methodName, Class[] argTypes, Throwable ex) throws FitFailureException {
        String args = Arrays.asList(argTypes).toString();
        args = "(" + args.substring(1, args.length() - 1) + ")";
        String problem = "Problem with accessing " + methodName + args + " of class " + this.type.getName() + ": " + ex;
        throw new FitFailureException(problem);
    }

    public void setTarget(Object element) {
        this.target = element;
    }

    public Object get() throws Exception {
        if (this.field != null) {
            return this.field.get(this.target);
        }
        if (this.method != null) {
            return this.method.invoke(this.target, new Object[0]);
        }
        return null;
    }

    public String getString() throws Exception {
        return this.get().toString();
    }

    public boolean matches(Cell cell, Object result) throws Exception {
        return this.matches(cell.parse, result);
    }

    public boolean matches(Parse cell, Object result) throws Exception {
        return this.equals(this.parse(new Cell(cell)), result);
    }

    public boolean equals(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }
}

