/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.valueAdapter;

import fit.Parse;
import fit.TypeAdapter;
import fitlibrary.FitLibraryFixture;
import fitlibrary.log.Logging;
import fitlibrary.parse.Cell;
import fitlibrary.valueAdapter.ValueAdapter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

public class ArrayValueAdapter
extends ValueAdapter {
    protected final TypeAdapter typeAdapter;
    protected final ValueAdapter valueAdapter;
    private Class componentType;

    public ArrayValueAdapter(FitLibraryFixture fixture, Class type, Method method, Field field) {
        this.typeAdapter = TypeAdapter.on(null, (Class)type);
        this.typeAdapter.fixture = fixture;
        this.typeAdapter.method = method;
        this.typeAdapter.field = field;
        this.componentType = type.getComponentType();
        this.valueAdapter = ValueAdapter.on(fixture, this.componentType, method, field, true);
    }

    public static boolean applicableType(Class type) {
        return type.isArray();
    }

    public Object parse(Cell cell) throws Exception {
        return this.parse(cell.parse);
    }

    public Object parse(Parse cell) throws Exception {
        String text = cell.text();
        Logging.log(this, "parse(" + text + ")");
        return this.parse(text);
    }

    public void setTarget(Object target) {
        this.typeAdapter.target = target;
    }

    public boolean matches(Cell cell, Object result) throws Exception {
        return this.matches(cell.parse, result);
    }

    public boolean matches(Parse cell, Object result) throws Exception {
        return this.equals(this.parse(cell), result);
    }

    public String getString() throws Exception {
        return this.toString(this.get());
    }

    public Object get() throws Exception {
        return this.typeAdapter.get();
    }

    private Object parse(String s) throws Exception {
        StringTokenizer t = new StringTokenizer(s, ",");
        Object array = Array.newInstance(this.componentType, t.countTokens());
        int i = 0;
        while (t.hasMoreTokens()) {
            Array.set(array, i, this.valueAdapter.parse(new Cell(t.nextToken())));
            ++i;
        }
        return array;
    }

    public String toString(Object o) throws ArrayIndexOutOfBoundsException, IllegalArgumentException, Exception {
        Logging.log(this, "toString(" + o + ")");
        if (o == null) {
            return "";
        }
        int length = Array.getLength(o);
        StringBuffer b = new StringBuffer(5 * length);
        int i = 0;
        while (i < length) {
            String element = this.valueAdapter.toString(Array.get(o, i));
            b.append(element);
            if (i < length - 1) {
                b.append(", ");
            }
            ++i;
        }
        return b.toString();
    }

    public boolean equals(Object a, Object b) {
        int length = Array.getLength(a);
        if (length != Array.getLength(b)) {
            return false;
        }
        int i = 0;
        while (i < length) {
            try {
                if (!this.valueAdapter.matches(new Cell(Array.get(a, i).toString()), Array.get(b, i))) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

