/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.tree;

import fitlibrary.tree.Tree;
import fitlibrary.tree.TreeInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class ListTree
implements Tree,
TreeInterface {
    private String title;
    private String text;
    private List children;

    public ListTree(String title, List children) {
        this.children = children;
        this.setTitle(title);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title.trim();
        this.setText(this.title);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String title) {
        this.text = ListTree.removeTags(title).trim();
    }

    public ListTree(List children) {
        this("", children);
    }

    public ListTree(String title, Tree[] children) {
        this(title, new ArrayList<Tree>(Arrays.asList(children)));
    }

    public ListTree(Tree[] children) {
        this("", Arrays.asList(children));
    }

    public ListTree(String title) {
        this(title, new ArrayList());
    }

    public ListTree(String name, ListTree tree) {
        this(name, new Tree[]{tree});
    }

    public List getChildren() {
        return this.children;
    }

    public void clearChildren() {
        this.children = new ArrayList();
    }

    public void addChild(ListTree tree) {
        this.children.add(tree);
    }

    public String toString() {
        if (this.children.isEmpty()) {
            return this.title;
        }
        String result = this.title + "<ul>";
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            result = result + "<li>" + ((ListTree)it.next()).toString() + "</li>";
        }
        return result + "</ul>";
    }

    public String text() {
        if (this.children.isEmpty()) {
            return this.text;
        }
        String result = this.text + "<ul>";
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            result = result + "<li>" + ((ListTree)it.next()).text() + "</li>";
        }
        return result + "</ul>";
    }

    public boolean equals(Object object) {
        return ListTree.equals(this, object);
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (!(o1 instanceof Tree) || !(o2 instanceof Tree)) {
            return false;
        }
        Tree t1 = (Tree)o1;
        Tree t2 = (Tree)o2;
        if (!t1.getText().equals(t2.getText())) {
            return false;
        }
        if (t1.getChildren().size() != t2.getChildren().size()) {
            return false;
        }
        Iterator otherIt = t2.getChildren().iterator();
        Iterator it = t1.getChildren().iterator();
        while (it.hasNext()) {
            Tree tree2;
            Tree tree1 = (Tree)it.next();
            if (ListTree.equals(tree1, tree2 = (Tree)otherIt.next())) continue;
            return false;
        }
        return true;
    }

    public static Tree parseTree(Tree tree) {
        return tree;
    }

    public static ListTree parse(String s) {
        int index = s.indexOf("<ul>");
        if (index < 0) {
            return new ListTree(s);
        }
        StringTokenizer tok = new StringTokenizer(s, "<");
        if (index == 0) {
            return ListTree.parse("", tok);
        }
        return ListTree.parse(tok.nextToken(), tok);
    }

    private static ListTree parse(String title, StringTokenizer tok) {
        ArrayList<ListTree> children = new ArrayList<ListTree>();
        String nextToken = tok.nextToken();
        while (tok.hasMoreTokens() && !nextToken.startsWith("ul>") && !nextToken.startsWith("/li>")) {
            title = title + "<" + nextToken;
            nextToken = tok.nextToken();
        }
        if (nextToken.startsWith("ul>")) {
            while (tok.hasMoreTokens()) {
                String t = tok.nextToken();
                if (!t.startsWith("/ul>")) {
                    if (!t.startsWith("li>")) continue;
                    String subTitle = t.substring("li>".length());
                    ListTree subTree = ListTree.parse(subTitle, tok);
                    children.add(subTree);
                    continue;
                }
                break;
            }
        } else if (!nextToken.startsWith("/li>")) {
            throw new RuntimeException("Bad list starting from " + nextToken);
        }
        return new ListTree(title, children);
    }

    private static String removeTags(String s) {
        String text = "";
        StringTokenizer tok = new StringTokenizer(s, "<");
        while (tok.hasMoreTokens()) {
            String nextToken = tok.nextToken();
            int index = nextToken.indexOf(">");
            text = text + nextToken.substring(index + 1);
        }
        return text;
    }

    public Tree toTree() {
        return this;
    }

    public String toString(int depth) {
        if (depth <= 1 || this.children.isEmpty()) {
            return this.title;
        }
        String result = this.title + "<ul>";
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            result = result + "<li>" + ((ListTree)it.next()).toString(depth - 1) + "</li>";
        }
        return result + "</ul>";
    }

    public String prune(int max) {
        int count = this.nodeCount(1);
        int depth = 2;
        int nextCount;
        while ((nextCount = this.nodeCount(depth)) <= max && nextCount != count) {
            count = nextCount;
            ++depth;
        }
        return this.toString(depth - 1);
    }

    private int nodeCount(int depth) {
        if (depth <= 1 || this.children.isEmpty()) {
            return 1;
        }
        int count = 1;
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            count += ((ListTree)it.next()).nodeCount(depth - 1);
        }
        return count;
    }
}

