/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.table;

import fit.Parse;
import fitlibrary.parse.ParseUtility;
import fitlibrary.table.TableInterface;

public class Table
implements TableInterface {
    private Parse parse;

    public Table(Parse parse) {
        this.parse = parse;
    }

    public Table tableAt(int i, int j, int k) {
        Parse at = this.parse.at((int)i, (int)j, (int)k).parts;
        return new Table(at);
    }

    public String stringAt(int i, int j, int k) {
        Parse p2 = this.parse.at(i, j, k);
        if (p2.body == null) {
            return "null";
        }
        return p2.text();
    }

    public Table toTable() {
        return this;
    }

    public static Table parseTable(Parse parse) {
        return new Table(parse);
    }

    public static boolean equals(Object expected, Object actual) {
        if (expected == null) {
            return actual == null;
        }
        return expected.equals(actual);
    }

    public boolean equals(Object actual) {
        if (!(actual instanceof Table)) {
            return false;
        }
        Table other = (Table)actual;
        return this.equalsParse(this.parse, other.parse);
    }

    public boolean equalsParse(Parse p1, Parse p2) {
        if (p1 == null) {
            return p2 == null;
        }
        if (p2 == null) {
            return false;
        }
        return p1.tag.equals(p2.tag) && this.equalStrings(p1.leader, p2.leader) && this.equalStrings(p1.body, p2.body) && this.equalStrings(p1.trailer, p2.trailer) && this.equalsParse(p1.more, p2.more) && this.equalsParse(p1.parts, p2.parts);
    }

    private boolean equalStrings(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public String toString() {
        return ParseUtility.toString(this.parse);
    }
}

