/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.suiteFixture;

import fit.Counts;
import fit.Fixture;
import fit.Parse;
import fitlibrary.DoFixture;
import fitlibrary.parse.Table;
import fitlibrary.suiteFixture.FitLibraryServer;
import fitlibrary.suiteFixture.FixtureSupplier;
import java.util.HashSet;
import java.util.Set;

public class SuiteFixture
extends DoFixture
implements FixtureSupplier {
    private boolean firstCall = true;
    private Set keys = new HashSet();

    protected static void registerSuiteFixture(FixtureSupplier fixtureSupplier) {
        FitLibraryServer.registerFixtureSupplier(fixtureSupplier);
    }

    public SuiteFixture() {
        SuiteFixture.registerSuiteFixture(this);
    }

    public boolean selectOr(String[] keywords) {
        int i = 0;
        while (i < keywords.length) {
            this.keys.add(keywords[i]);
            ++i;
        }
        return true;
    }

    public void keywords(String[] keywords) {
        if (this.keys.isEmpty()) {
            return;
        }
        boolean selected = false;
        int i = 0;
        while (i < keywords.length) {
            selected = selected || this.keys.contains(keywords[i]);
            ++i;
        }
        if (!selected) {
            this.abandonStorytest(null);
        }
    }

    protected Fixture getLinkedFixtureWithArgs(Parse tables) throws Throwable {
        return this;
    }

    public void interpretTables(Parse tables) {
        if (this.firstCall) {
            super.interpretTables(tables);
            this.firstCall = false;
        } else {
            Parse tablesWithTableInFront = new Parse("table", "", new Parse("tr", "", null, null), tables);
            super.interpretTables(tablesWithTableInFront);
        }
    }

    protected void interpretTable(Table table) {
        this.interpretTable(table.parse);
    }

    protected void interpretTable(Parse table) {
        try {
            Parse cells = table.parts.parts;
            Object result = this.interpretCells(cells, null);
            if (result instanceof DoFixture) {
                DoFixture doFixture = (DoFixture)((Object)result);
                doFixture.listener = this.listener;
                doFixture.counts = this.counts;
                doFixture.interpretTables(table);
                this.passOverStorytest();
                return;
            }
            if (result instanceof Fixture) {
                this.interpretTableWithFixture(new Table(table), (Fixture)result);
            } else {
                this.doTable(table);
            }
        }
        catch (Throwable e) {
            this.exception(table.at(0, 0, 0), e);
        }
        this.listener.tableFinished(table);
    }

    public Fixture getFixture() {
        this.counts = new Counts();
        return this;
    }
}

