/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.specify;

import fitlibrary.CalculateFixture;
import fitlibrary.DoFixture;
import fitlibrary.FitLibraryFixture;
import fitlibrary.SetUpFixture;
import fitlibrary.ref.EntityReference;
import java.util.ArrayList;
import java.util.List;

public class References
extends DoFixture {
    private List accounts = new ArrayList();
    private List accountReferences = new ArrayList();

    public References() {
        this.setSystemUnderTest(new Sut());
    }

    public CalculateFixture calculateReference(String entityName) {
        return new CalculateReference(entityName);
    }

    public SetUpFixture setUpAccounts() {
        return new SetUpAccounts();
    }

    public SetUpFixture setUpTransactionsFor(Account account) {
        return new SetUpTransAction(account);
    }

    public boolean addTo(int amount, Account account) {
        account.add(amount);
        return true;
    }

    public List accounts() {
        return this.accounts;
    }

    public Account findAccount(int index) {
        if (index >= this.accounts.size()) {
            throw new RuntimeException("Unavailable: Account#" + index);
        }
        return (Account)this.accounts.get(index);
    }

    public Account findAccount(String text) {
        if (text.equals("1st")) {
            return this.findAccount(0);
        }
        throw new RuntimeException("Unavailable: Account from '" + text + "'");
    }

    public Account with(Account account) {
        return account;
    }

    public DoFixture withAccount(Account account) {
        return new AccountDoFixture(account, this);
    }

    public Object showAccount(Account arg) {
        return EntityReference.reference(arg, this.accounts);
    }

    public Person withPerson(Person person) {
        return person;
    }

    public SetUpAccountRefs getSetUpAccountReferences() {
        SetUpAccountRefs setUpAccountRefs = new SetUpAccountRefs();
        setUpAccountRefs.setOuterContext(this);
        return setUpAccountRefs;
    }

    public List checkAccountReferences() {
        return this.accountReferences;
    }

    public static class AccountRef {
        private Account account;

        public AccountRef(Account account) {
            this.account = account;
        }

        public Account getAccount() {
            return this.account;
        }
    }

    public class SetUpAccountRefs
    extends SetUpFixture {
        public void account(Account account) {
            References.this.accountReferences.add(new AccountRef(account));
        }
    }

    public static class AccountDoFixture
    extends DoFixture {
        private Account account;

        public AccountDoFixture(Account account, FitLibraryFixture fixture) {
            super(account);
            this.account = account;
            this.setOuterContext(fixture);
        }

        public Transaction withTransaction(Transaction transaction) {
            return transaction;
        }

        public Transaction findTransaction(int index) {
            List transactions = this.account.getTransactions();
            if (index >= transactions.size()) {
                throw new RuntimeException("Unavailable: Transaction#" + index);
            }
            return (Transaction)transactions.get(index);
        }

        public Account this_() {
            return this.account;
        }
    }

    public static class Transaction {
        private String details;

        public Transaction(String details) {
            this.details = details;
        }

        public String getDetails() {
            return this.details;
        }
    }

    public static class SetUpTransAction
    extends SetUpFixture {
        private Account account;

        public SetUpTransAction(Account account) {
            this.account = account;
        }

        public void details(String details) {
            this.account.add(new Transaction(details));
        }
    }

    public static class Sut {
        public Person findPerson(int index) {
            return new Person();
        }
    }

    public static class Person {
        public String getName() {
            return "ward";
        }
    }

    public static class Account {
        private int owing;
        private List transactions = new ArrayList();

        public Account(int owing) {
            this.owing = owing;
        }

        public void add(int amount) {
            this.owing += amount;
        }

        public int getOwing() {
            return this.owing;
        }

        public void add(Transaction details) {
            this.transactions.add(details);
        }

        public List getTransactions() {
            return this.transactions;
        }
    }

    public class SetUpAccounts
    extends SetUpFixture {
        public void owing(int owing) {
            References.this.accounts.add(new Account(owing));
        }
    }

    public class CalculateReference
    extends CalculateFixture {
        private EntityReference entityReference;

        public CalculateReference(String entityName) {
            this.entityReference = EntityReference.create(entityName);
        }

        public int indexText(String text) {
            return this.entityReference.getIndex(text);
        }
    }
}

