/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.spec;

import fit.Fixture;
import fit.Parse;
import fit.exception.FitFailureException;
import fit.exception.NestedTableExpected;
import fit.exception.RowWrongWidthException;
import fitlibrary.parse.Cell;
import fitlibrary.parse.ParseUtility;
import fitlibrary.parse.Row;
import fitlibrary.parse.Table;
import fitlibrary.spec.SpecifyFixture;
import fitlibrary.suiteFixture.FitLibraryServer;

public class SpecifySuiteFixture
extends SpecifyFixture {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTable(Parse table) {
        try {
            this.doTable(new Table(table));
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            FitLibraryServer.clearFixtureSupplierRegistration();
            throw throwable;
        }
        FitLibraryServer.clearFixtureSupplierRegistration();
    }

    private void doTable(Table theTable) {
        int rowNo = 1;
        while (rowNo < theTable.size()) {
            Row row = theTable.row(rowNo);
            if (row.size() < 2) {
                this.exception(theTable, new RowWrongWidthException(2));
            }
            Cell test = row.cell(0);
            Cell report = row.cell(1);
            if (!test.hasParts()) {
                this.exception(theTable, new NestedTableExpected());
                return;
            }
            Parse actual = test.parse.parts;
            Parse expected = report.parse.parts;
            Fixture fixture = FitLibraryServer.getFixture();
            fixture.doTables(actual);
            if (SpecifyFixture.reportsEqual(actual, expected)) {
                report.right(this.counts);
            } else {
                report.wrong(this.counts);
                ParseUtility.printParse(actual, "actual");
                this.addTableToBetterShowDifferences(theTable.parse, actual, expected);
            }
            ++rowNo;
        }
    }

    private void exception(Table theTable, FitFailureException e) {
        this.exception(theTable.row((int)0).cell((int)0).parse, e);
    }
}

