/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.spec;

import fit.Fixture;
import fit.Parse;
import fit.exception.FitParseException;
import fitlibrary.parse.ParseUtility;

public class SpecifyFixture
extends Fixture {
    public void doTable(Parse table) {
        Parse firstRow = table.parts.more;
        Parse actual = firstRow.parts.parts;
        Parse secondRow = firstRow.more;
        Parse expectedCell = secondRow != null ? secondRow.parts : firstRow.parts.more;
        Parse expected = expectedCell.parts;
        new Fixture().doTables(actual);
        if (SpecifyFixture.reportsEqual(actual, expected)) {
            this.right(expectedCell);
        } else {
            this.wrong(expectedCell);
            ParseUtility.printParse(actual, "actual");
            this.addTableToBetterShowDifferences(table, actual, expected);
        }
    }

    protected void addTableToBetterShowDifferences(Parse table, Parse actual, Parse expected) {
        Parse end = table.last();
        Parse cells1 = new Parse("td", "fitlibrary.CommentFixture", null, null);
        Parse cells2 = new Parse("td", "actual", null, new Parse("td", "expected", null, null));
        Parse cells3 = new Parse("td", SpecifyFixture.show(actual), null, new Parse("td", SpecifyFixture.show(expected), null, null));
        Parse rows = new Parse("tr", "", cells1, new Parse("tr", "", cells2, new Parse("tr", "", cells3, null)));
        end.more = new Parse("table", "", rows, null);
    }

    private static String show(Parse parse) {
        if (parse == null) {
            return "null";
        }
        String result = "&lt;" + parse.tag.substring(1, parse.tag.length() - 1) + "&gt;<ul>";
        result = result + SpecifyFixture.showField("leader", parse.leader);
        result = parse.parts != null ? result + SpecifyFixture.show(parse.parts) : result + SpecifyFixture.showField("body", parse.body);
        result = result + SpecifyFixture.showField("trailer", parse.trailer);
        result = result + "</ul>";
        if (parse.more != null) {
            result = result + SpecifyFixture.show(parse.more);
        }
        return result;
    }

    private static String showField(String field, String value) {
        if (value != null && !value.trim().equals("")) {
            return "<li>" + field + ": '" + SpecifyFixture.noTags(value) + "'";
        }
        return "";
    }

    private static String noTags(String value) {
        int index;
        while ((index = value.indexOf("<")) >= 0) {
            value = value.substring(0, index) + "&lt;" + value.substring(index + 1);
        }
        return value;
    }

    public static boolean reportsEqual(Parse actual, Parse expected) {
        if (actual == null) {
            return expected == null;
        }
        if (expected == null) {
            return false;
        }
        SpecifyFixture.massageBodyToTable(actual);
        boolean result = SpecifyFixture.equalTags(actual, expected) && SpecifyFixture.equalStrings(actual.leader, expected.leader) && SpecifyFixture.equalBodies(actual, expected) && SpecifyFixture.equalStrings(actual.trailer, expected.trailer) && SpecifyFixture.reportsEqual(actual.more, expected.more) && SpecifyFixture.reportsEqual(actual.parts, expected.parts);
        return result;
    }

    private static void massageBodyToTable(Parse actual) {
        if (actual.body == null || actual.body.indexOf("<table") < 0) {
            return;
        }
        if (actual.parts == null) {
            try {
                actual.parts = new Parse(actual.body);
            }
            catch (FitParseException e) {
                // empty catch block
            }
        }
        actual.body = "";
    }

    private static boolean equalBodies(Parse actual, Parse expected) {
        boolean result = SpecifyFixture.equalBodies22(actual, expected);
        if (!result) {
            System.out.println("!SpecifyFixture.equalBodies(\"" + actual.body + "\",\"" + expected.body + "\")");
        }
        return result;
    }

    private static boolean equalBodies22(Parse actual, Parse expected) {
        int endSpan;
        String expectedBody = SpecifyFixture.canonicalString(expected.body);
        String actualBody = SpecifyFixture.canonicalString(actual.body);
        if (expectedBody.equals("IGNORE")) {
            return true;
        }
        if (actualBody.equals(expectedBody)) {
            return true;
        }
        String stackTrace = "class=\"fit_stacktrace\">";
        int start = expectedBody.indexOf(stackTrace);
        if (start >= 0) {
            String pattern = expectedBody.substring(0, start + stackTrace.length());
            return actual.body.startsWith(pattern);
        }
        String errorMessage = "<span class=\"fit_label\">";
        start = expectedBody.indexOf(errorMessage);
        if (start >= 0 && (endSpan = expectedBody.indexOf("</span>", start)) >= 0) {
            String pattern = expectedBody.substring(0, endSpan - 1);
            return actual.body.startsWith(pattern);
        }
        return false;
    }

    private static String canonicalString(String body) {
        body = body == null ? "" : body.trim();
        return body;
    }

    private static boolean equalTags(Parse p1, Parse p2) {
        return p1.tag.equals(p2.tag);
    }

    private static boolean equalStrings(String actual, String expected) {
        boolean result = SpecifyFixture.equalStrings22(actual, expected);
        if (!result) {
            System.out.println("!SpecifyFixture.equals(\"" + actual + "\",\"" + expected + "\")");
        }
        return result;
    }

    private static boolean equalStrings22(String actual, String expected) {
        if (actual == null) {
            return expected == null || expected.trim().equals("") || expected.equals("\n");
        }
        if (expected == null) {
            return actual.trim().equals("") || actual.equals("\n");
        }
        if (expected.equals("IGNORE")) {
            return true;
        }
        return actual.trim().equals(expected.trim());
    }
}

