/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.runner;

import fit.Counts;
import fitlibrary.FitLibraryFixture;
import fitlibrary.runner.FolderRunner;
import fitlibrary.tree.ListTree;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class ReportHtml {
    private static Random random = new Random(System.currentTimeMillis());
    private final String title;
    private final String path;
    private final File reportDiry;
    private final String topReportDiryName;
    private String leafRows = "";

    public ReportHtml(String title, String path, File reportDiry, File topReportDiry) {
        this.title = title;
        this.path = path;
        this.reportDiry = reportDiry;
        this.topReportDiryName = topReportDiry.getAbsolutePath() + "/";
    }

    public String html(ListTree tree) {
        return "<html><head><title>" + this.title + "</title>\n" + this.headerLinks() + "</head><body>" + this.toggledList(tree) + "\n</body></html>";
    }

    private String toggledList(ListTree tree) {
        List treeChildren = tree.getChildren();
        if (treeChildren.isEmpty()) {
            return tree.getTitle();
        }
        String result = "<ul>";
        Iterator it = treeChildren.iterator();
        while (it.hasNext()) {
            result = result + "<li>" + this.toggledList((ListTree)it.next()) + "</li>\n";
        }
        return tree.getTitle() + this.toggledHtml(result + "</ul>", "Sub-Folders");
    }

    private String toggledHtml(String body, String foldingTitle) {
        int id = random.nextInt();
        return "<div class=\"main\">\n <div class=\"setup\">\n  <a href=\"javascript:toggleCollapsable('" + id + "');\">\n" + "  <img src=\"" + this.path + "files/images/collapsableOpen.gif\" class=\"left\" id=\"img" + id + "\"/>\n" + "  </a>\n" + " <i>" + foldingTitle + ":</i>\n" + "  <div class=\"collapsable\" id=\"" + id + "\">\n" + body + " </div></div></div>\n";
    }

    public void addTableRow(File reportFile, Counts counts) {
        this.leafRows = this.leafRows + "<tr><td></td><td>" + this.linkToReportIndexInDiry(reportFile) + "</td>" + ReportHtml.tableCell(counts) + "</tr>\n";
    }

    public String title(ReportHtml reportHtml, Counts pageCounts, Counts assertionCounts) {
        String result = this.header(pageCounts, assertionCounts) + "</table>\n";
        if (!this.leafRows.equals("")) {
            result = result + reportHtml.toggledHtml("<table>" + this.leafRows + "</table>\n", "Files");
        }
        return result;
    }

    private String header(Counts pageCounts, Counts assertionCounts) {
        String result = "<table border cellspacing=0 cellpadding=3><tr>";
        result = this.reportDiry == null ? result + "<td><b>" + this.title + "</b></td>" : result + "<td>" + this.linkToDiry(this.title, this.reportDiry) + "</td>";
        result = result + ReportHtml.tableCell(pageCounts) + ReportHtml.tableCell(assertionCounts) + "</tr>\n";
        return result;
    }

    public String headerLinks() {
        return "\t<link rel=\"stylesheet\" type=\"text/css\" href=\"" + this.path + "files/css/fitnesse.css\" media=\"screen\"/>\n" + "\t<link rel=\"stylesheet\" type=\"text/css\" href=\"" + this.path + "files/css/fitnesse.css\" media=\"print\"/>\n" + this.javascript(this.path);
    }

    private static String tableCell(Counts counts) {
        return ReportHtml.colour("td", counts) + counts + "</td>";
    }

    private static String colour(String tag, Counts counts) {
        if (counts.wrong > 0) {
            return ReportHtml.colorTag(tag, "fail");
        }
        if (counts.exceptions > 0) {
            return ReportHtml.colorTag(tag, "fit_stacktrace");
        }
        if (counts.right > 0) {
            return ReportHtml.colorTag(tag, "pass");
        }
        return ReportHtml.colorTag(tag, "ignore");
    }

    private static String colorTag(String tag, String color) {
        return "<" + tag + " class=\"" + color + "\"" + ">";
    }

    private static String link(File file) {
        return "<A HREF=\"" + ReportHtml.reportName(file) + "\">" + ReportHtml.stripSuffix(file.getName()) + "</A>";
    }

    private String linkToDiry(String title, File file) {
        String relativePath = this.relativeUrl(file);
        return "<A HREF=\"" + relativePath + "\">" + title + "</A>";
    }

    private String relativeUrl(File file) {
        String relativePath = file.getAbsolutePath();
        if (relativePath.length() > this.topReportDiryName.length()) {
            relativePath = relativePath.substring(this.topReportDiryName.length());
        }
        return FitLibraryFixture.replaceString(relativePath, "\\", "/");
    }

    private String linkToReportIndexInDiry(File file) {
        String relativePath = this.relativeUrl(file);
        return "<A HREF=\"" + ReportHtml.reportName(relativePath) + "\">" + ReportHtml.stripSuffix(file.getName()) + "</A>";
    }

    private static String stripSuffix(String name) {
        String upperName = name.toUpperCase();
        int pos = upperName.indexOf(".HTM");
        if (pos < 0) {
            return name;
        }
        return name.substring(0, name.length() - ".html".length());
    }

    public static String reportName(File file) {
        return ReportHtml.reportName(file.getName());
    }

    private static String reportName(String name) {
        if (FolderRunner.isHtmlFileName(name)) {
            return name;
        }
        int pos = name.indexOf(".");
        if (pos < 0) {
            return name + "/" + "reportIndex.html";
        }
        return name.substring(0, pos) + name.substring(pos + 1) + ".html";
    }

    private String javascript(String path) {
        return "<script language=\"JavaScript\" type=\"text/javascript\">\nvar collapsableOpenCss = \"collapsable\"\nvar collapsableClosedCss = \"hidden\"\nvar collapsableOpenImg = \"" + path + "/files/images/collapsableOpen.gif\"\n" + "var collapsableClosedImg = \"" + path + "/files/images/collapsableClosed.gif\"\n" + "function toggleCollapsable(id){\n" + "var div = document.getElementById(id);\n" + "var img = document.getElementById(\"img\" + id);\n" + "if(div.className.indexOf(collapsableClosedCss) != -1) {\n" + "  div.className = collapsableOpenCss;\n" + "  img.src = collapsableOpenImg;\n" + "} else {\n" + "  div.className = collapsableClosedCss;\n" + "  img.src = collapsableClosedImg;\n" + "} }\n" + "</script>\n";
    }
}

