/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.runner;

import fit.Counts;
import fitlibrary.runner.ReportHtml;
import fitlibrary.tree.ListTree;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Report {
    private Counts pageCounts = new Counts();
    private Counts assertionCounts = new Counts();
    private ListTree tree = new ListTree("");
    private Report parent;
    private List children = new ArrayList();
    private ReportHtml reportHtml;

    public Report() {
    }

    public Report(String title, File reportDiry, Report parent, String path, boolean top, File topReportDiry) {
        this.parent = parent;
        this.reportHtml = new ReportHtml(title, path, reportDiry, topReportDiry);
        if (parent != null) {
            this.connectTrees(parent);
        }
    }

    public String getCounts() {
        return this.pageCounts.toString();
    }

    public String getAssertionCounts() {
        return this.assertionCounts.toString();
    }

    public String getHtml() {
        return this.reportHtml.html(this.copySummariesWithLeaves(this));
    }

    private ListTree copySummariesWithLeaves(Report report) {
        ListTree copy = new ListTree(this.getTitleWithLeaves(report));
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            Report child = (Report)it.next();
            copy.addChild(child.copySummariesWithLeaves(report));
        }
        return copy;
    }

    private void setTitleOfTree() {
        this.tree.setTitle(this.getTitleWithLeaves(this));
    }

    private String getTitleWithLeaves(Report report) {
        return this.reportHtml.title(report.reportHtml, this.pageCounts, this.assertionCounts);
    }

    public Report firstChild() {
        if (this.children.isEmpty()) {
            return null;
        }
        return (Report)this.children.get(0);
    }

    public void exit() {
        System.err.println(this.assertionCounts);
        System.exit(this.assertionCounts.wrong + this.assertionCounts.exceptions);
    }

    public void addAssertionCountsForPage(File reportFile, Counts counts) {
        this.incrementPageCounts(counts);
        this.addAssertions(counts);
        this.reportHtml.addTableRow(reportFile, counts);
    }

    public void setFinished() {
        if (this.pageCounts.right + this.pageCounts.wrong + this.pageCounts.exceptions + this.pageCounts.ignores == 0) {
            ++this.pageCounts.ignores;
        }
        this.setTitleOfTree();
    }

    private void incrementPageCounts(Counts counts) {
        if (counts.wrong > 0) {
            ++this.pageCounts.wrong;
        } else if (counts.exceptions > 0) {
            ++this.pageCounts.exceptions;
        } else if (counts.right > 0) {
            ++this.pageCounts.right;
        } else {
            ++this.pageCounts.ignores;
        }
        if (this.parent != null) {
            this.parent.incrementPageCounts(counts);
        }
    }

    private void connectTrees(Report toParent) {
        toParent.tree.addChild(this.tree);
        toParent.addChild(this);
    }

    private void addChild(Report counts) {
        this.children.add(counts);
    }

    private void addAssertions(Counts counts) {
        Report.add(this.assertionCounts, counts);
        if (this.parent != null) {
            this.parent.addAssertions(counts);
        }
    }

    protected static boolean failing(Counts counts) {
        return counts.wrong + counts.exceptions > 0;
    }

    protected boolean failing() {
        return Report.failing(this.pageCounts);
    }

    private static void add(Counts toCounts, Counts counts) {
        toCounts.right += counts.right;
        toCounts.wrong += counts.wrong;
        toCounts.exceptions += counts.exceptions;
        toCounts.ignores += counts.ignores;
    }

    public String addLinks(String html, File input) {
        String body = "<body";
        int index = html.indexOf(body);
        if (index < 0) {
            index = html.indexOf("<BODY");
        }
        if (index < 0) {
            throw new RuntimeException("Missing &lt;body&gt; in HTML file: " + input.getAbsolutePath());
        }
        int endTag = html.indexOf(">", index);
        html = html.substring(0, endTag + 1) + this.reportHtml.headerLinks() + html.substring(endTag + 1);
        return html;
    }
}

