/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.runner;

import fit.Parse;
import fitlibrary.parse.ParseUtility;
import fitlibrary.runner.CustomRunnerException;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class MakeParse {
    private static final String NO_TABLE_STARTED = "No table started";
    private Parse tables = null;
    private Parse currentTable = null;
    private Parse currentRow = null;
    private String webPageTitle;

    public MakeParse(String webPageTitle) {
        this.webPageTitle = webPageTitle;
    }

    public void addTable(String[] table) throws CustomRunnerException {
        if (table.length == 0) {
            throw new CustomRunnerException("Table needs at least one row.");
        }
        this.addTable(table[0]);
        int i = 1;
        while (i < table.length) {
            this.addRow(table[i]);
            ++i;
        }
    }

    public void addTable(String firstRow) throws CustomRunnerException {
        this.addTableWithLeaderText(firstRow, "");
    }

    public void addTableWithLeaderText(String firstRow, String leader) throws CustomRunnerException {
        this.addTable(this.getCellValues(firstRow), leader);
    }

    public void addTable(String[] cells, String leader) throws CustomRunnerException {
        this.startNewTable(new Parse("table", "", null, null));
        this.currentTable.addToTag(" border cellspacing=0 cellpadding=3");
        this.currentTable.leader = this.currentTable.leader + leader;
        if (this.tables != null) {
            this.currentTable.leader = this.currentTable.leader + "<br>";
        }
        this.addRow(cells);
    }

    public void addTables(Parse table) {
        if (this.currentTable != null) {
            this.endTable();
        }
        if (this.tables == null) {
            this.tables = table;
            ParseUtility.changeHeader(this.tables, this.header());
        } else {
            ParseUtility.append(this.tables, table);
        }
    }

    public void addTablesWithoutChangingHeader(Parse table) {
        if (this.currentTable != null) {
            this.endTable();
        }
        if (this.tables == null) {
            this.tables = table;
        } else {
            ParseUtility.append(this.tables, table);
        }
    }

    public void addTableTrailerWithoutBreaks(String text) {
        this.addTableTrailer(text, "");
    }

    public void addTableTrailer(String text) {
        this.addTableTrailer(text, "<br>");
    }

    private void addTableTrailer(String text, String breakString) {
        int index;
        Parse table = this.currentTable;
        if (this.currentTable == null) {
            if (this.tables == null) {
                throw new CustomRunnerException(NO_TABLE_STARTED);
            }
            table = this.tables.last();
        }
        table.trailer = table.trailer == null || table.trailer.equals("") ? "" + text : ((index = table.trailer.indexOf("</body>")) < 0 ? table.trailer + breakString + text : table.trailer.substring(0, index) + breakString + text + table.trailer.substring(index));
    }

    public Parse addRow(String cells) throws CustomRunnerException {
        return this.addRow(this.getCellValues(cells));
    }

    public Parse addRow(String[] cells) throws CustomRunnerException {
        if (this.currentTable == null) {
            throw new CustomRunnerException(NO_TABLE_STARTED);
        }
        if (this.currentRow != null) {
            this.endRow();
        }
        this.currentRow = new Parse("tr", "", null, null);
        int i = 0;
        while (i < cells.length) {
            this.addCell(cells[i]);
            ++i;
        }
        return this.currentRow;
    }

    public Parse getTables() {
        this.endTables();
        return this.tables;
    }

    public void print(PrintWriter report) {
        this.endTables();
        this.tables.print(report);
    }

    public void print(String title) {
        this.endTables();
        ParseUtility.printParse(this.tables, title);
    }

    public String toString() {
        this.endTables();
        return ParseUtility.toString(this.tables);
    }

    private void startNewTable(Parse table) {
        if (this.currentTable != null) {
            this.endTable();
        }
        this.currentTable = table;
    }

    private void endTable() throws CustomRunnerException {
        if (this.currentTable == null) {
            throw new CustomRunnerException(NO_TABLE_STARTED);
        }
        if (this.currentRow != null) {
            this.endRow();
        }
        if (this.currentTable.parts == null) {
            throw new CustomRunnerException("Table has no rows");
        }
        if (this.tables == null) {
            this.tables = this.currentTable;
        } else {
            ParseUtility.append(this.tables, this.currentTable);
        }
        this.colSpan(this.currentTable);
        this.currentTable = null;
        this.currentRow = null;
    }

    private void colSpan(Parse table) {
        int length = 0;
        Parse rows = table.parts;
        while (rows != null) {
            length = Math.max(length, rows.parts.size());
            rows = rows.more;
        }
        rows = table.parts;
        while (rows != null) {
            int span = length - rows.parts.size() + 1;
            if (span > 1) {
                rows.parts.last().addToTag(" ColSpan=" + span);
            }
            rows = rows.more;
        }
    }

    private String[] getCellValues(String cells) {
        int count = 0;
        StringTokenizer st = new StringTokenizer(cells, ",|");
        while (st.hasMoreTokens()) {
            ++count;
            st.nextToken();
        }
        String[] row = new String[count];
        int i = 0;
        StringTokenizer st2 = new StringTokenizer(cells, ",|");
        while (st2.hasMoreTokens()) {
            row[i] = st2.nextToken();
            ++i;
        }
        return row;
    }

    private void endRow() {
        if (this.currentRow.parts == null) {
            throw new CustomRunnerException("Row is empty");
        }
        this.addToParts(this.currentTable, this.currentRow);
        this.currentRow = null;
    }

    private void addToParts(Parse node, Parse part) {
        if (node.parts == null) {
            node.parts = part;
        } else {
            node.parts.last().more = part;
        }
    }

    private void addCell(String body) throws CustomRunnerException {
        if (this.currentTable == null) {
            throw new CustomRunnerException(NO_TABLE_STARTED);
        }
        if (this.currentRow == null) {
            throw new CustomRunnerException("No row started");
        }
        Parse td = new Parse("td", body, null, null);
        this.addToParts(this.currentRow, td);
    }

    private void endTables() throws CustomRunnerException {
        if (this.currentTable != null) {
            this.endTable();
        }
        if (this.tables == null) {
            throw new CustomRunnerException("No table included");
        }
        ParseUtility.changeHeader(this.tables, this.header());
        ParseUtility.completeTrailer(this.tables);
    }

    private String header() {
        return "<html><head><title>" + this.webPageTitle + "</title></head><body>";
    }
}

