/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.runner;

import fit.Counts;
import fit.Fixture;
import fit.Parse;
import fit.exception.FitParseException;
import fitlibrary.parse.ParseUtility;
import fitlibrary.runner.Report;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.Date;

public class HtmlRunner {
    private Report report;

    public HtmlRunner() {
    }

    public HtmlRunner(Report report) {
        this.report = report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Counts runInSuite(String title, File inFile, File report, String encoding, Parse setUp, Parse tearDown) throws IOException, ParseException {
        if (!report.canWrite()) {
            // empty if block
        }
        Fixture fixture = this.getFixtureWithSummary(inFile, report);
        PrintWriter output = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(report), encoding));
        String fileContents = this.read(inFile, encoding);
        try {
            Parse tables = new Parse(fileContents);
            Parse whole = HtmlRunner.integrateSetUpAndTearDown(tables, setUp, tearDown);
            Counts counts = this.runTable(fixture, output, whole);
            whole.print(output);
            Counts counts2 = counts;
            Object var15_16 = null;
            output.close();
            return counts2;
        }
        catch (FitParseException e) {
            try {
                output.print(fileContents);
                Counts counts = fixture.counts;
                Object var15_17 = null;
                output.close();
                return counts;
            }
            catch (Throwable throwable) {
                Object var15_18 = null;
                output.close();
                throw throwable;
            }
        }
    }

    public Parse getParse(File inFile, String encoding) throws ParseException, IOException {
        return new Parse(this.read(inFile, encoding));
    }

    public static Parse integrateSetUpAndTearDown(Parse tables, Parse setUp, Parse tearDown) {
        Parse whole = tables;
        if (setUp != null) {
            whole = setUp;
            ParseUtility.appendToSetUp(whole, tables);
        }
        if (tearDown != null) {
            ParseUtility.append(whole, tearDown);
        }
        return whole;
    }

    private Counts runTable(Fixture fixture, PrintWriter output, Parse tables) {
        fixture.doTables(tables);
        return fixture.counts;
    }

    private Fixture getFixtureWithSummary(File inFile, File report) {
        Fixture fixture = new Fixture();
        fixture.summary.put("input file", inFile.getAbsolutePath());
        fixture.summary.put("input update", new Date(inFile.lastModified()));
        fixture.summary.put("output file", report.getAbsolutePath());
        return fixture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String read(File input, String encoding) throws IOException {
        StringBuffer result;
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(input), encoding));
        try {
            String s;
            result = new StringBuffer();
            while ((s = in.readLine()) != null) {
                result.append(s);
                result.append("\n");
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            in.close();
            throw throwable;
        }
        in.close();
        String string = result.toString();
        if (this.report == null) {
            return string;
        }
        return this.report.addLinks(string, input);
    }

    private Counts errorCounts(Fixture fixture, String error, Exception e, PrintWriter output) {
        Parse pseudoTables = new Parse("body", "<i>" + error + e + "</i>", null, null);
        pseudoTables.print(output);
        output.close();
        fixture.exception(pseudoTables, (Throwable)e);
        return fixture.counts;
    }

    public Parse collectTable(File file, String encoding) throws ParseException, IOException {
        return this.getParse(file, encoding);
    }
}

