/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.runner;

import fit.Counts;
import fit.Parse;
import fitlibrary.FitLibraryFixture;
import fitlibrary.differences.FolderRunnerDifference;
import fitlibrary.parse.ParseUtility;
import fitlibrary.runner.CopyFiles;
import fitlibrary.runner.CustomRunnerException;
import fitlibrary.runner.HtmlRunner;
import fitlibrary.runner.Report;
import fitlibrary.runner.ReportHtml;
import fitlibrary.runner.SpreadsheetRunner;
import fitlibrary.runner.TestListener;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class FolderRunner {
    private static final String FILES = "files";
    public static final String INDEX_HTML = "reportIndex.html";
    protected String encoding = "ASCII";
    private static final Set SETUPS = new HashSet<String>(Arrays.asList("SETUP.XLS", "SETUP.HTML", "SETUP.HTM"));
    private static final Set TEARDOWNS = new HashSet<String>(Arrays.asList("TEARDOWN.XLS", "TEARDOWN.HTML", "TEARDOWN.HTM"));
    private Report topReport = new Report();
    private List testListeners = new ArrayList();
    private File inDiry;
    private File reportDiry;

    public static void main(String[] args) throws ParseException, IOException {
        Report report = new FolderRunner(args).run();
        report.exit();
    }

    public FolderRunner() {
        FitLibraryFixture.setFolderRunnerStrategy();
    }

    public FolderRunner(String[] args) throws ParseException, IOException {
        this();
        switch (args.length) {
            case 0: {
                this.setTestFile("tests");
                return;
            }
            case 1: {
                this.setTestFile(args[0]);
                return;
            }
            case 2: {
                this.setFiles(args[0], args[1]);
                return;
            }
            case 3: {
                this.setFiles(args[0], args[1]);
                this.encoding = args[2];
                return;
            }
        }
        System.err.println("Usage: java fitlibrary.runner.FolderRunner\nOr:    java fitlibrary.runner.FolderRunner testFolder\nOr:    java fitlibrary.runner.FolderRunner testFolder reportFolder\nOr:    java fitlibrary.runner.FolderRunner testFolder reportFolder unicodeEncoding");
        System.exit(-1);
    }

    public Report run(String testDiry) throws ParseException, IOException {
        this.setTestFile(testDiry);
        return this.run();
    }

    public Report run(String inDiry, String reportDiry) throws ParseException, IOException {
        this.setFiles(inDiry, reportDiry);
        return this.run();
    }

    public Report run() throws ParseException, IOException {
        if (!this.inDiry.exists() || !this.inDiry.isDirectory()) {
            throw new RuntimeException("Folder is needed for input: " + this.inDiry.getAbsolutePath());
        }
        if (this.reportDiry.exists()) {
            if (!this.reportDiry.isDirectory()) {
                throw new RuntimeException("File exists but is not a directory: " + this.reportDiry.getAbsolutePath());
            }
        } else if (!this.reportDiry.mkdir()) {
            throw new RuntimeException("Unable to create folder " + this.reportDiry.getAbsolutePath());
        }
        if (this.reportDiry.getAbsolutePath().startsWith(this.inDiry.getAbsolutePath())) {
            throw new RuntimeException("The reports folder can't be inside the tests folder: it'll run forever!");
        }
        this.copyCssAndImageFilesFromJar(this.inDiry);
        Parse setUpTables = new Parse("table", "", null, null);
        Parse tearDownTables = null;
        boolean top = true;
        String title = "";
        File topReportDiry = this.reportDiry;
        this.runDiry(title, this.inDiry, this.reportDiry, this.topReport, setUpTables, tearDownTables, "", top, topReportDiry);
        this.suiteFinished();
        return this.topReport;
    }

    private void runDiry(String title, File inDiry, File reportDiry, Report parentReport, Parse setUpTables, Parse tearDownTables, String path, boolean top, File topReportDiry) throws ParseException, IOException {
        FolderRunnerDifference.setCurrentTestDiryFile(inDiry);
        String diryName = inDiry.getName();
        File reportFile = new File(reportDiry, INDEX_HTML);
        if (FolderRunner.fileIsLocked(reportFile)) {
            throw new RuntimeException("Already running");
        }
        Report report = new Report(title, reportDiry, parentReport, path, top, topReportDiry);
        Parse fullSetUpTables = this.appendSetUp(setUpTables, inDiry);
        Parse fullTearDownTables = this.prependTearDown(tearDownTables, inDiry);
        File filesFile = new File(inDiry, FILES);
        if (filesFile.exists()) {
            CopyFiles.copyFilesRecursively(inDiry, reportDiry, FILES);
        }
        File[] files = inDiry.listFiles();
        int i = 0;
        while (i < files.length) {
            this.giveFeedbackToUser();
            File file = files[i];
            String name = file.getName();
            if (file.isDirectory()) {
                if (this.canRunThisFolder(name)) {
                    File subReportDiry = new File(reportDiry, name);
                    if (!subReportDiry.exists()) {
                        subReportDiry.mkdir();
                    }
                    this.runDiry(title + "." + file.getName(), file, subReportDiry, report, fullSetUpTables, fullTearDownTables, path + "../", false, topReportDiry);
                    FolderRunnerDifference.setCurrentTestDiryFile(inDiry);
                }
            } else if (!FolderRunner.specialFileName(name)) {
                this.runFile(title + "." + file.getName(), file, reportDiry, report, fullSetUpTables, fullTearDownTables);
            }
            ++i;
        }
        report.setFinished();
        if (top) {
            this.writeReport(reportFile, report.getHtml());
        }
    }

    private boolean canRunThisFolder(String name) {
        return !name.equals(FILES) && !name.startsWith(".") && !name.equals("CVS");
    }

    private void writeReport(File reportFile, String reportHtml) throws IOException {
        PrintWriter output = new PrintWriter(new BufferedWriter(new FileWriter(reportFile)));
        output.print(reportHtml);
        output.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runFile(String title, File file, File reportDiry, Report report, Parse fullSetUpTables, Parse fullTearDownTables) {
        PrintStream oldErr;
        PrintStream oldOut;
        block8: {
            block7: {
                String name = file.getName();
                oldOut = System.out;
                oldErr = System.err;
                ByteArrayOutputStream tempOut = new ByteArrayOutputStream();
                ByteArrayOutputStream tempErr = new ByteArrayOutputStream();
                if (!FolderRunner.isXlsFileName(name) && !FolderRunner.isHtmlFileName(name)) {
                    this.ignoreFile(file);
                    return;
                }
                try {
                    try {
                        File reportFile = new File(reportDiry, FolderRunner.reportName(file));
                        if (FolderRunner.fileIsLocked(reportFile)) {
                            Object var17_14 = null;
                            break block7;
                        }
                        System.setOut(new PrintStream(tempOut));
                        System.setErr(new PrintStream(tempErr));
                        Parse setUp = this.copyParse(fullSetUpTables.more);
                        Parse tearDown = this.copyParse(fullTearDownTables);
                        FitLibraryFixture.setContext(reportDiry);
                        Counts counts = FolderRunner.isXlsFileName(name) ? new SpreadsheetRunner(report).run(file, reportFile, setUp, tearDown) : new HtmlRunner(report).runInSuite(title, file, reportFile, this.encoding, setUp, tearDown);
                        report.addAssertionCountsForPage(reportFile, counts);
                        this.reportOutput(name, "out", tempOut.toString());
                        this.reportOutput(name, "err", tempErr.toString());
                        break block8;
                    }
                    catch (Exception e) {
                        this.ignoreFile(file);
                        Object var17_16 = null;
                        System.setOut(oldOut);
                        System.setErr(oldErr);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var17_17 = null;
                    System.setOut(oldOut);
                    System.setErr(oldErr);
                    throw throwable;
                }
            }
            System.setOut(oldOut);
            System.setErr(oldErr);
            return;
        }
        Object var17_15 = null;
        System.setOut(oldOut);
        System.setErr(oldErr);
    }

    private static boolean fileIsLocked(File file) {
        boolean locked;
        boolean bl = locked = file.exists() && !file.canWrite();
        if (locked) {
            System.err.println("FolderRunner: File is locked: " + file.getAbsolutePath());
        }
        return locked;
    }

    public static boolean specialFileName(String mixedCaseName) {
        String name = mixedCaseName.toUpperCase();
        return SETUPS.contains(name) || TEARDOWNS.contains(name);
    }

    private Parse appendSetUp(Parse tables, File inDiry) throws IOException {
        Parse newTables = this.copyParse(tables);
        this.gatherTables(inDiry, SETUPS, newTables.last());
        return newTables;
    }

    private Parse copyParse(Parse parse) {
        return ParseUtility.copyParse(parse);
    }

    private Parse prependTearDown(Parse tables, File inDiry) throws IOException {
        Parse newTables = new Parse("", "", null, null);
        this.gatherTables(inDiry, TEARDOWNS, newTables);
        ParseUtility.append(newTables, this.copyParse(tables));
        return newTables.more;
    }

    private static String reportName(File file) {
        return ReportHtml.reportName(file);
    }

    private Parse gatherTables(File inDiry, Set matching, Parse endTable) throws FileNotFoundException, IOException {
        File xlsFile = null;
        File htmlFile = null;
        File[] files = inDiry.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            String name = file.getName().toUpperCase();
            if (matching.contains(name)) {
                if (FolderRunner.isXlsFileName(name)) {
                    xlsFile = file;
                } else {
                    if (htmlFile != null) {
                        throw new RuntimeException("Can't have .html and .htm files in " + inDiry.getAbsolutePath());
                    }
                    htmlFile = file;
                }
                endTable = endTable.last();
            }
            ++i;
        }
        try {
            if (xlsFile != null) {
                ParseUtility.append(endTable, new SpreadsheetRunner().collectTable(xlsFile));
            }
        }
        catch (CustomRunnerException e) {
            this.ignoreFile(htmlFile);
        }
        try {
            if (htmlFile != null) {
                ParseUtility.append(endTable, new HtmlRunner().collectTable(htmlFile, this.encoding));
            }
        }
        catch (ParseException e) {
            this.ignoreFile(htmlFile);
        }
        return endTable;
    }

    private void ignoreFile(File file) {
    }

    public static boolean isHtmlFileName(String name) {
        String upperName = name.toUpperCase();
        return upperName.endsWith(".HTML") || upperName.endsWith(".HTM");
    }

    public static boolean isXlsFileName(String name) {
        return name.toUpperCase().endsWith(".XLS");
    }

    private void copyCssAndImageFilesFromJar(File inDiry) throws IOException {
        File cssDiry;
        File filesDiry = new File(inDiry, FILES);
        if (!filesDiry.exists()) {
            filesDiry.mkdir();
        }
        if (!(cssDiry = new File(filesDiry, "css")).exists()) {
            cssDiry.mkdir();
        }
        this.createFileIfNeeded(new File(cssDiry, "fitnesse.css"), "css/fitnesse.css");
        File imagesDiry = new File(filesDiry, "images");
        if (!imagesDiry.exists()) {
            imagesDiry.mkdir();
        }
        this.createFileIfNeeded(new File(imagesDiry, "collapsableClosed.gif"), "images/collapsableClosed.gif");
        this.createFileIfNeeded(new File(imagesDiry, "collapsableOpen.gif"), "images/collapsableClosed.gif");
    }

    private void createFileIfNeeded(File target, String resource) throws FileNotFoundException, IOException {
        int ch;
        if (target.exists()) {
            return;
        }
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        InputStream reader = classLoader.getResourceAsStream(resource);
        BufferedOutputStream writer = new BufferedOutputStream(new FileOutputStream(target));
        while ((ch = reader.read()) >= 0) {
            writer.write(ch);
        }
        reader.close();
        writer.close();
    }

    private void setTestFile(String testDiryName) {
        this.inDiry = new File(testDiryName);
        this.reportDiry = new File(this.inDiry.getParentFile(), "reports");
    }

    private void setFiles(String testDiryName, String reportDiryName) {
        this.inDiry = new File(testDiryName);
        this.reportDiry = new File(reportDiryName);
    }

    public void addTestListener(TestListener listener) {
        this.testListeners.add(listener);
    }

    private void giveFeedbackToUser() {
        Iterator it = this.testListeners.iterator();
        while (it.hasNext()) {
            ((TestListener)it.next()).testComplete(this.topReport.failing(), this.topReport.getCounts(), this.topReport.getAssertionCounts());
        }
    }

    private void reportOutput(String name, String out, String message) {
        Iterator it = this.testListeners.iterator();
        while (it.hasNext()) {
            ((TestListener)it.next()).reportOutput(name, out, message);
        }
    }

    private void suiteFinished() {
        Iterator it = this.testListeners.iterator();
        while (it.hasNext()) {
            ((TestListener)it.next()).suiteComplete();
        }
    }

    public void exit() {
        this.topReport.exit();
    }
}

