/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.ref;

import fit.exception.FitFailureException;
import fitlibrary.log.Logging;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EntityReference {
    private static String[] forms = new String[]{"this", "the"};
    private static String[] counts = new String[]{"first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eigth", "nineth", "tenth"};
    private static Map entityReferenceCache = new HashMap();
    private Map mapStringToInt = new HashMap();
    private String entityClassName;

    public static EntityReference create(String name) {
        EntityReference ref = (EntityReference)entityReferenceCache.get(name);
        if (ref == null) {
            ref = new EntityReference(name);
            entityReferenceCache.put(name, ref);
        }
        return ref;
    }

    protected EntityReference(String entityClassName) {
        this.entityClassName = entityClassName;
        this.createMap();
    }

    private void createMap() {
        int form = 0;
        while (form < forms.length) {
            String theForm = forms[form];
            this.put(theForm, new Integer(0));
            this.put(theForm + " " + this.entityClassName, new Integer(0));
            this.put(theForm + " last", new Integer(-1));
            this.put(theForm + " last " + this.entityClassName, new Integer(-1));
            int count = 0;
            while (count < counts.length) {
                String theCountString = counts[count];
                Integer theCount = new Integer(count);
                this.put(theCountString, theCount);
                this.put(theForm + " " + theCountString, theCount);
                this.put(theForm + " " + theCountString + " " + this.entityClassName, theCount);
                this.put(this.entityClassName + "#" + (count + 1), theCount);
                ++count;
            }
            ++form;
        }
    }

    private void put(String referenceString, Integer index) {
        this.mapStringToInt.put(referenceString.toLowerCase(), index);
    }

    public int getIndex(String text) {
        Integer result = (Integer)this.mapStringToInt.get(text.toLowerCase());
        if (result == null) {
            throw new FitFailureException("Reference not defined: '" + text + "'");
        }
        return result;
    }

    private String reference(int index, int count) {
        if (count == 1) {
            return "the " + this.entityClassName;
        }
        if (index >= counts.length) {
            return this.entityClassName + "#" + (index + 1);
        }
        return "the " + counts[index] + " " + this.entityClassName;
    }

    public static String reference(Object object, List list) {
        int index = list.indexOf(object);
        String className = Logging.simpleClassName(object.getClass());
        EntityReference referenceParser = new EntityReference(className);
        return referenceParser.reference(index, list.size());
    }
}

