/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.parse;

import fit.Counts;
import fit.FixtureListener;
import fit.Parse;
import fit.exception.MissingRowFailureException;
import fitlibrary.FitLibraryFixture;
import fitlibrary.parse.ParseNode;
import fitlibrary.parse.ParseUtility;
import fitlibrary.parse.Row;

public class Table
extends ParseNode {
    public Table(Parse parse) {
        super(parse);
    }

    public int size() {
        return this.parse.parts.size();
    }

    public Row row(int i) {
        if (!this.rowExists(i)) {
            throw new MissingRowFailureException("");
        }
        return new Row(this.parse.parts.at(i));
    }

    public boolean rowExists(int i) {
        return i >= 0 && i < this.size();
    }

    public String toString() {
        return "Table[" + ParseUtility.toString(this.parse.parts) + "]";
    }

    public void right(Counts counts) {
        this.row(0).right(counts);
    }

    public void wrong(Counts counts) {
        this.row(0).wrong(counts);
    }

    public void wrong(Counts counts, String msg) {
        this.row(0).cell(0).wrong(counts, msg);
    }

    public void missing(Counts counts) {
        this.row(0).missing(counts);
    }

    public void ignore(Counts counts) {
        this.row(0).ignore(counts);
    }

    public void exception(FitLibraryFixture fixture, Throwable e) {
        this.row(0).exception(fixture, e);
    }

    public Row lastRow() {
        return this.row(this.size() - 1);
    }

    public void addRow(Row row) {
        this.parse.parts.last().more = row.parse;
    }

    public void finished(FixtureListener listener) {
        listener.tableFinished(this.parse);
    }
}

