/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.parse;

import fit.Counts;
import fit.Parse;
import fit.exception.MissingCellsFailureException;
import fitlibrary.FitLibraryFixture;
import fitlibrary.parse.Cell;
import fitlibrary.parse.ParseNode;
import fitlibrary.parse.ParseUtility;

public class Row
extends ParseNode {
    public Row(Parse parse) {
        super(parse);
    }

    public Row() {
        this(new Parse("tr", "", null, null));
    }

    public int size() {
        return this.parse.parts.size();
    }

    public Cell cell(int i) {
        if (!this.cellExists(i)) {
            throw new MissingCellsFailureException("");
        }
        return new Cell(this.parse.parts.at(i));
    }

    public boolean cellExists(int i) {
        return i >= 0 && i < this.size();
    }

    public String toString() {
        return "Row[" + ParseUtility.toString(this.parse.parts) + "]";
    }

    public void exception(FitLibraryFixture fixture, Throwable e) {
        this.cell(0).exception(fixture, e);
    }

    public String text(int i) {
        return this.cell(i).text();
    }

    public void missing(Counts counts) {
        this.cell(0).missing(counts);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Row)) {
            return false;
        }
        Row other = (Row)object;
        if (other.size() != this.size()) {
            return false;
        }
        int i = 0;
        while (i < this.size()) {
            if (!this.cell(i).equals(other.cell(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

