/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.parse;

import fit.Parse;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;

public class ParseUtility {
    public static final String ASCII_ENCODING = "ASCII";
    private static final String START_BODY = "<body>";
    public static final String END_BODY = "</body>";

    public static String toString(Parse parse) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        parse.print(printWriter);
        printWriter.close();
        return stringWriter.toString();
    }

    public static void printParse(Parse tables, String title) {
        System.out.println("---------Parse tables for " + title + ":----------");
        if (tables != null) {
            PrintWriter printWriter = new PrintWriter(System.out);
            tables.print(printWriter);
            printWriter.flush();
        }
        System.out.println("-------------------");
    }

    public static void addRowToTable(Parse table, String[] cells) {
        Parse root;
        if (cells.length == 0) {
            throw new RuntimeException("Can't have an empty row.");
        }
        Parse here = root = new Parse(null, null, null, null);
        int i = 0;
        while (i < cells.length) {
            here = here.more = new Parse("td", cells[i], null, null);
            ++i;
        }
        table.parts.last().more = new Parse("tr", "", root.more, null);
    }

    protected void addRowToTable(Parse table, String s) {
        ParseUtility.addRowToTable(table, new String[]{s});
    }

    public static void appendToSetUp(Parse front, Parse back) {
        if (back == null) {
            return;
        }
        ParseUtility.changeHeader(front, ParseUtility.removeHeader(back));
        ParseUtility.fixTrailers(front, back);
        front.last().more = back;
    }

    public static void append(Parse front, Parse back) {
        if (back == null) {
            return;
        }
        ParseUtility.removeHeader(back);
        ParseUtility.fixTrailers(front, back);
        front.last().more = back;
    }

    public static void fixTrailers(Parse front, Parse back) {
        String frontTrailer;
        Parse frontLast = front.last();
        String extra = frontTrailer = frontLast.trailer;
        int index = frontTrailer.indexOf(END_BODY);
        if (index >= 0) {
            extra = frontTrailer.substring(0, index);
        }
        if (!extra.equals("")) {
            back.leader = back.leader.equals("\n<br>") ? extra + back.leader : extra + "<br>" + back.leader;
        }
        frontLast.trailer = "";
    }

    public static String removeHeader(Parse tables) {
        int index = tables.leader.indexOf(START_BODY);
        if (index < 0) {
            return "";
        }
        String result = tables.leader.substring(0, index += START_BODY.length());
        tables.leader = tables.leader.substring(index);
        return result;
    }

    public static void changeHeader(Parse tables, String tablesHeader) {
        int index = tables.leader.indexOf(START_BODY);
        tables.leader = index < 0 ? tablesHeader + tables.leader : tablesHeader + tables.leader.substring(index + START_BODY.length());
    }

    public static void completeTrailer(Parse tables) {
        Parse last = tables.last();
        int index = last.trailer.indexOf(END_BODY);
        if (index < 0) {
            last.trailer = last.trailer + "\n</body></html>\n";
        }
    }

    public static Parse copyParse(Parse tables) {
        if (tables == null) {
            return null;
        }
        Parse parse = new Parse("", tables.body, ParseUtility.copyParse(tables.parts), ParseUtility.copyParse(tables.more));
        parse.tag = tables.tag;
        parse.end = tables.end;
        parse.leader = tables.leader;
        parse.trailer = tables.trailer;
        return parse;
    }

    public static void writeParse(File report, Parse parse) throws UnsupportedEncodingException, FileNotFoundException {
        PrintWriter output = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(report), ASCII_ENCODING));
        parse.print(output);
        output.close();
    }
}

