/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.parse;

import fit.Counts;
import fit.Parse;
import fitlibrary.FitLibraryFixture;

public class ParseNode {
    public final String PASS = " class=\"pass\"";
    public final String FAIL = " class=\"fail\"";
    public final String IGNORE = " class=\"ignore\"";
    public final String ERROR = " class=\"error\"";
    public Parse parse;

    public ParseNode(Parse parse) {
        this.parse = parse;
    }

    public void right(Counts counts) {
        this.ensureBodyNotNull();
        this.parse.addToTag(" class=\"pass\"");
        ++counts.right;
    }

    public void wrong(Counts counts) {
        this.ensureBodyNotNull();
        this.parse.addToTag(" class=\"fail\"");
        ++counts.wrong;
    }

    public void exception(FitLibraryFixture fixture, Throwable e) {
        this.ensureBodyNotNull();
        fixture.exception(this.parse, e);
    }

    public void ignore(Counts counts) {
        this.ensureBodyNotNull();
        this.parse.addToTag(" class=\"ignore\"");
        ++counts.ignores;
    }

    public static String label(String string) {
        return " <span class=\"fit_label\">" + string + "</span>";
    }

    public boolean isRight() {
        return this.parse.tag.endsWith(" class=\"pass\">");
    }

    public boolean isWrong() {
        return this.parse.tag.endsWith(" class=\"fail\">");
    }

    public boolean isIgnored() {
        return this.parse.tag.endsWith(" class=\"ignore\">");
    }

    public boolean hasException() {
        return this.parse.tag.endsWith(" class=\"error\">");
    }

    private void ensureBodyNotNull() {
        if (this.parse.body == null) {
            this.parse.body = "";
        }
    }
}

