/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.parse;

import fit.Counts;
import fit.Fixture;
import fit.Parse;
import fitlibrary.parse.ParseNode;
import fitlibrary.parse.ParseUtility;

public class Cell
extends ParseNode {
    public Cell(Parse parse) {
        super(parse);
    }

    public Cell(String cellText) {
        this(new Parse("", cellText, null, null));
    }

    public String text() {
        if (this.parse.body == null) {
            return "";
        }
        return this.parse.text();
    }

    public boolean blank() {
        return this.text().equals("");
    }

    public boolean hasParts() {
        return this.parse.parts != null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Cell)) {
            return false;
        }
        Cell other = (Cell)object;
        return this.parse.body.equals(other.parse.body);
    }

    public void wrong(Counts counts, String msg) {
        this.wrong(counts);
        this.parse.addToBody(ParseNode.label("expected") + "<hr>" + Fixture.escape((String)msg) + ParseNode.label("actual"));
    }

    public void missing(Counts counts) {
        this.wrong(counts);
        this.parse.addToBody(ParseNode.label("missing"));
    }

    public void surplus(Counts counts) {
        this.wrong(counts);
        this.parse.addToBody(ParseNode.label("surplus"));
    }

    public String toString() {
        if (this.hasParts()) {
            return "Cell[" + ParseUtility.toString(this.parse.parts) + "]";
        }
        return this.text();
    }
}

