/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.graphic;

import fitlibrary.graphic.DotGraphic;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ObjectDotGraphic
extends DotGraphic {
    private int nodeNo = 0;
    private String[] exclusions = new String[]{"sun.", "com.sun.", "org.omg.", "javax.", "sunw.", "java.", "org.w3c.dom.", "org.xml.sax.", "net.jini."};
    private HashMap visited = new HashMap();
    private List queue = new LinkedList();
    private int nodesToProcess = 50;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Boolean;

    public ObjectDotGraphic(Object object) {
        super("");
        String firstNodeID = "n0";
        this.dot = "digraph G {\n" + this.visit(object, firstNodeID) + this.buildGraph() + "}\n";
    }

    private String buildGraph() {
        String result = "";
        while (!this.queue.isEmpty() && --this.nodesToProcess > 0) {
            Object object = this.queue.remove(0);
            String objectID = (String)this.visited.get(object);
            Class<?> type = object.getClass();
            result = object instanceof Set ? result + this.buildSetGraph(objectID, (Set)object) : (object instanceof Map ? result + this.buildSetGraph(objectID, ((Map)object).entrySet()) : (object instanceof Collection ? result + this.buildCollectionGraph(objectID, (Collection)object) : (object instanceof Object[] ? result + this.buildCollectionGraph(objectID, Arrays.asList((Object[])object)) : result + this.buildObjectGraph(objectID, object, this.getAllFields(type)))));
        }
        return result;
    }

    private Object[] getAllFields(Class type) {
        LinkedList fields = new LinkedList();
        this.getAllFields(type, fields);
        return fields.toArray();
    }

    private void getAllFields(Class type, List list) {
        list.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type != (class$java$lang$Object == null ? (class$java$lang$Object = ObjectDotGraphic.class$("java.lang.Object")) : class$java$lang$Object)) {
            this.getAllFields(type.getSuperclass(), list);
        }
    }

    private String buildObjectGraph(String objectID, Object object, Object[] fields) {
        String result = "";
        int i = 0;
        while (i < fields.length) {
            Field field = (Field)fields[i];
            try {
                String name = field.getName();
                Object value = field.get(object);
                result = result + this.makeArc(objectID, value, name);
            }
            catch (IllegalAccessException e) {
                result = result + this.accessThroughProperty(field, objectID, object);
            }
            ++i;
        }
        return result;
    }

    private String firstUpper(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private String accessThroughProperty(Field field, String objectID, Object object) {
        String name = this.firstUpper(field.getName());
        String methodName = "get" + name;
        if (field.getType().equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ObjectDotGraphic.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            methodName = "is" + name;
        }
        try {
            Method method = object.getClass().getMethod(methodName, new Class[0]);
            Object value = method.invoke(object, new Object[0]);
            return this.makeArc(objectID, value, name);
        }
        catch (Exception e) {
            return "";
        }
    }

    private String makeArc(String objectID, Object value, String label) {
        String result = "";
        String valueID = (String)this.visited.get(value);
        if (valueID == null) {
            ++this.nodeNo;
            valueID = "n" + this.nodeNo;
            result = result + this.visit(value, valueID);
        }
        result = result + objectID + " -> " + valueID + " [label=\"" + label + "\"];\n";
        return result;
    }

    private String visit(Object object, String nodeID) {
        this.visited.put(object, nodeID);
        if (this.excluded(object)) {
            return nodeID + " [label = \"" + object.toString() + "\"];\n";
        }
        this.queue.add(object);
        Class<?> type = object.getClass();
        if (type.isArray()) {
            return nodeID + " [label = \"" + type.getComponentType().getName() + "[]\"];\n";
        }
        if (this.collectionSetOrMap(object)) {
            return nodeID + " [shape=box, label = \"" + type.getName() + "\"];\n";
        }
        return nodeID + " [label = \"" + type.getName() + "\"];\n";
    }

    private String buildCollectionGraph(String objectID, Collection collection) {
        String result = "";
        int count = 0;
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            Object value = it.next();
            result = result + this.makeArc(objectID, value, "[" + count + "]");
            ++count;
        }
        return result;
    }

    private String buildSetGraph(String objectID, Set set) {
        String result = "";
        int count = 0;
        Iterator it = set.iterator();
        while (it.hasNext()) {
            Object value = it.next();
            result = result + this.makeArc(objectID, value, "");
            ++count;
        }
        return result;
    }

    private boolean excluded(Object object) {
        if (this.collectionSetOrMap(object)) {
            return false;
        }
        String name = object.getClass().getName();
        int i = 0;
        while (i < this.exclusions.length) {
            if (name.startsWith(this.exclusions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean collectionSetOrMap(Object object) {
        return object instanceof Collection || object instanceof Set || object instanceof Map;
    }

    public Object getDot() {
        return this.dot;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

