/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.differences;

import fitlibrary.FitLibraryFixture;
import fitlibrary.differences.LocalFile;
import fitlibrary.log.Logging;
import java.io.File;

public class FolderRunnerLocalFile
implements LocalFile {
    private File file;
    private static File CONTEXT = new File(".");

    public FolderRunnerLocalFile(File file) {
        this.file = file;
    }

    public FolderRunnerLocalFile(String localFileName) {
        if (!localFileName.startsWith("files/") && !localFileName.startsWith("files\\")) {
            localFileName = "files/" + localFileName;
        }
        Logging.log(this, "FolderRunnerLocalFile(): " + localFileName);
        this.file = new File(localFileName);
    }

    public LocalFile withSuffix(String suffix) {
        String name = this.file.getPath();
        int last = name.lastIndexOf(".");
        if (last >= 0) {
            name = name.substring(0, last + 1) + suffix;
        }
        Logging.log(this, "withSuffix(): " + name);
        return new FolderRunnerLocalFile(name);
    }

    public File getFile() {
        File absoluteFile = new File(CONTEXT, this.file.getPath());
        Logging.log(this, "getFile(): " + absoluteFile.getAbsolutePath());
        return absoluteFile;
    }

    public void mkdir() {
        File filesFolder = new File(CONTEXT, "files");
        if (!filesFolder.exists()) {
            filesFolder.mkdir();
        }
        File file = new File(filesFolder, this.getFile().getName());
        Logging.log(this, "mkdir(): " + file.getAbsolutePath());
        if (!file.exists()) {
            file.mkdir();
        }
    }

    public String htmlImageLink() {
        return "<img src=\"" + FitLibraryFixture.replaceString(this.file.getPath(), "\\", "/") + "\">";
    }

    public String htmlLink() {
        return "<a href=\"file:///" + FitLibraryFixture.replaceString(this.file.getAbsolutePath(), "\\", "/") + "\">" + this.file.getName() + "</a>";
    }

    public boolean equals(Object object) {
        if (!(object instanceof FolderRunnerLocalFile)) {
            return false;
        }
        String absolutePath = ((FolderRunnerLocalFile)object).file.getPath();
        String otherAbsolutePath = this.file.getPath();
        boolean equals = absolutePath.equals(otherAbsolutePath);
        Logging.log(this, "equals(): " + equals + " with: '" + absolutePath + "' and '" + otherAbsolutePath);
        return equals;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public String toString() {
        return "FolderRunnerLocalFile[" + this.file.getName() + "]";
    }

    public static void setContext(File context) {
        CONTEXT = context;
    }
}

