/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.closure;

import fit.Fixture;
import fit.Parse;
import fit.exception.FitFailureException;
import fit.exception.IgnoredException;
import fitlibrary.ArrayFixture;
import fitlibrary.DoFixture;
import fitlibrary.DomainObjectCheckFixture;
import fitlibrary.FitLibraryFixture;
import fitlibrary.SetFixture;
import fitlibrary.closure.MethodClosure;
import fitlibrary.log.Logging;
import fitlibrary.parse.Cell;
import fitlibrary.parse.Row;
import fitlibrary.valueAdapter.MetaValueAdapter;
import fitlibrary.valueAdapter.ValueAdapter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MethodTarget {
    private final MethodClosure methodClosure;
    private final FitLibraryFixture fixture;
    private final ValueAdapter[] parameterAdapters;
    private ValueAdapter resultAdapter = null;
    private final Object[] args;
    private String repeatString = null;
    private String exceptionString = null;
    private boolean everySecond = false;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Iterator;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Void;

    public static MethodTarget findSpecificMethod(String name, int args, Object subject, FitLibraryFixture fixture) {
        MethodClosure chosenMethod = MethodClosure.findMethod(subject, name, args);
        if (chosenMethod == null && args == 0) {
            chosenMethod = MethodClosure.findProperty(subject, name);
        }
        if (chosenMethod == null) {
            return null;
        }
        return new MethodTarget(chosenMethod, fixture);
    }

    public MethodTarget(MethodClosure method, FitLibraryFixture fixture) {
        this.methodClosure = method;
        this.fixture = fixture;
        Class[] types = this.getParameterTypes();
        this.parameterAdapters = new ValueAdapter[types.length];
        this.args = new Object[types.length];
        int i = 0;
        while (i < types.length) {
            this.parameterAdapters[i] = ValueAdapter.on(fixture, types[i]);
            ++i;
        }
        Class returnType = this.getReturnType();
        if (returnType != Void.TYPE) {
            this.resultAdapter = ValueAdapter.onResult(fixture, method.getMethod());
        }
    }

    public boolean isValid() {
        return this.methodClosure != null;
    }

    public Class getReturnType() {
        return this.methodClosure.getMethod().getReturnType();
    }

    public Class[] getParameterTypes() {
        return this.methodClosure.getMethod().getParameterTypes();
    }

    public Object invoke(Object[] arguments) throws Exception {
        return this.methodClosure.invoke(arguments);
    }

    public Object invoke(Row row) throws Exception {
        return this.invoke(row.parse.parts);
    }

    public Object invoke(Cell cell) throws Exception {
        return this.invoke(cell.parse);
    }

    public Object invoke(Parse cells) throws Exception {
        try {
            if (this.everySecond) {
                this.collectEverySecondCell(cells);
            } else {
                this.collectAllCells(cells);
            }
        }
        catch (Exception e) {
            throw new IgnoredException(e);
        }
        return this.invoke(this.args);
    }

    private void collectAllCells(Parse cells) throws Exception {
        int argNo = 0;
        while (argNo < this.args.length) {
            this.collectCell(cells, argNo, cells.text());
            cells = cells.more;
            ++argNo;
        }
    }

    private void collectEverySecondCell(Parse cells) throws Exception {
        int argNo = 0;
        while (argNo < this.args.length) {
            this.collectCell(cells, argNo, cells.text());
            cells = cells.more;
            if (cells != null) {
                cells = cells.more;
            }
            ++argNo;
        }
    }

    private void collectCell(Parse cells, int argNo, String text) throws Exception {
        try {
            if (!text.equals(this.repeatString)) {
                this.args[argNo] = this.parameterAdapters[argNo].parse(new Cell(cells));
            }
        }
        catch (Exception e) {
            this.fixture.exception(cells, e);
            throw e;
        }
    }

    public void invokeAndCheck(Row row, Cell expectedCell) {
        this.invokeAndCheck(row.parse.parts, expectedCell.parse);
    }

    public void invokeAndCheck(Row row, Parse expectedCell) {
        this.invokeAndCheck(row.parse.parts, expectedCell);
    }

    public void invokeAndCheck(Parse cells, Parse expectedCell) {
        Object result = null;
        boolean exceptionExpected = this.exceptionString != null && this.exceptionString.equals(expectedCell.text());
        try {
            result = this.invoke(cells);
            if (exceptionExpected) {
                this.fixture.wrong(expectedCell);
                return;
            }
        }
        catch (IgnoredException ex) {
            return;
        }
        catch (FitFailureException e) {
            return;
        }
        catch (Exception e) {
            if (exceptionExpected) {
                this.fixture.right(expectedCell);
            } else {
                this.fixture.exception(expectedCell, e);
            }
            return;
        }
        this.checkResult(expectedCell, result);
    }

    public void checkResult(Parse expectedCell, Object result) {
        block8: {
            try {
                if (this.resultAdapter == null) {
                    throw new FitFailureException("No value provided");
                }
                String toString = this.resultAdapter.toString(result);
                if (this.resultAdapter instanceof MetaValueAdapter) {
                    if (this.resultAdapter.matches(new Cell(expectedCell), result)) {
                        this.fixture.right(expectedCell);
                    } else {
                        this.fixture.wrongHtml(expectedCell, toString);
                    }
                    break block8;
                }
                if (this.resultAdapter.matches(new Cell(expectedCell), result)) {
                    if (expectedCell.parts != null) break block8;
                    this.fixture.right(expectedCell);
                    break block8;
                }
                if (expectedCell.parts == null) {
                    this.fixture.wrong(expectedCell, toString);
                }
            }
            catch (Exception e) {
                this.fixture.exception(expectedCell, e);
            }
        }
    }

    public Object getResult(Parse expectedCell) {
        try {
            return this.resultAdapter.parse(new Cell(expectedCell));
        }
        catch (Exception e) {
            return null;
        }
    }

    public void color(Parse cells, boolean right) throws Exception {
        while (cells != null) {
            if (right) {
                this.fixture.right(cells);
            } else {
                this.fixture.wrong(cells);
            }
            if (!this.everySecond) break;
            cells = cells.more;
            if (cells == null) continue;
            cells = cells.more;
        }
    }

    public void setRepeatAndExceptionString(String repeatString, String exceptionString) {
        this.repeatString = repeatString;
        this.exceptionString = exceptionString;
    }

    public void setEverySecond(boolean everySecond) {
        this.everySecond = everySecond;
    }

    private Object wrapObjectWithFixture(Object result) {
        if (this.isPrimitiveReturnType()) {
            return result;
        }
        if (result instanceof String) {
            return result;
        }
        if (result instanceof Fixture) {
            return result;
        }
        if (this.isObjectArrayReturnType()) {
            return this.withOuter(new ArrayFixture((Object[])result));
        }
        if (this.returnAssignableTo(class$java$util$Set == null ? (class$java$util$Set = MethodTarget.class$("java.util.Set")) : class$java$util$Set)) {
            return this.withOuter(new SetFixture(((Set)result).toArray()));
        }
        if (this.returnAssignableTo(class$java$util$Collection == null ? (class$java$util$Collection = MethodTarget.class$("java.util.Collection")) : class$java$util$Collection)) {
            return this.withOuter(new ArrayFixture((Collection)result));
        }
        if (this.returnAssignableTo(class$java$util$Iterator == null ? (class$java$util$Iterator = MethodTarget.class$("java.util.Iterator")) : class$java$util$Iterator)) {
            return this.withOuter(new ArrayFixture((Iterator)result));
        }
        if (this.returnAssignableTo(class$java$util$Map == null ? (class$java$util$Map = MethodTarget.class$("java.util.Map")) : class$java$util$Map)) {
            return this.withOuter(new SetFixture(((Map)result).values().toArray()));
        }
        if (ValueAdapter.hasStaticParseMethod(result.getClass())) {
            return result;
        }
        return this.withOuter(new DoFixture(result));
    }

    private Object withOuter(FitLibraryFixture inner) {
        Logging.log((Object)inner, "Wrapped result: " + inner.getSystemUnderTest());
        inner.setOuterContext(this.fixture);
        return inner;
    }

    private boolean isPrimitiveReturnType() {
        return this.getReturnType().isPrimitive();
    }

    private boolean isObjectArrayReturnType() {
        Class returnType = this.getReturnType();
        return returnType.isArray() && !returnType.getComponentType().isArray() && (class$java$lang$Object == null ? (class$java$lang$Object = MethodTarget.class$("java.lang.Object")) : class$java$lang$Object).isAssignableFrom(returnType.getComponentType());
    }

    private boolean returnAssignableTo(Class type) {
        return type.isAssignableFrom(this.getReturnType());
    }

    public Object invokeAndWrap(Parse cells) throws Exception {
        return this.wrapObjectWithFixture(this.invoke(cells));
    }

    public Object invokeAndWrapForDomain(Parse cells) throws Exception {
        return this.wrapObjectWithFixtureForDomain(this.invoke(cells));
    }

    private Object wrapObjectWithFixtureForDomain(Object result) {
        if (this.isPrimitiveReturnType()) {
            return result;
        }
        if (result instanceof String) {
            return result;
        }
        if (result instanceof Fixture) {
            return result;
        }
        if (this.isObjectArrayReturnType()) {
            return this.withOuter(new ArrayFixture((Object[])result));
        }
        if (this.returnAssignableTo(class$java$util$Set == null ? (class$java$util$Set = MethodTarget.class$("java.util.Set")) : class$java$util$Set)) {
            return this.withOuter(new SetFixture(((Set)result).toArray()));
        }
        if (this.returnAssignableTo(class$java$util$Collection == null ? (class$java$util$Collection = MethodTarget.class$("java.util.Collection")) : class$java$util$Collection)) {
            return this.withOuter(new ArrayFixture((Collection)result));
        }
        if (this.returnAssignableTo(class$java$util$Iterator == null ? (class$java$util$Iterator = MethodTarget.class$("java.util.Iterator")) : class$java$util$Iterator)) {
            return this.withOuter(new ArrayFixture((Iterator)result));
        }
        if (this.returnAssignableTo(class$java$util$Map == null ? (class$java$util$Map = MethodTarget.class$("java.util.Map")) : class$java$util$Map)) {
            return this.withOuter(new SetFixture(((Map)result).values().toArray()));
        }
        if (ValueAdapter.hasStaticParseMethod(result.getClass())) {
            return result;
        }
        return this.withOuter(new DomainObjectCheckFixture(result));
    }

    public String getResultString(Object result) throws Exception {
        if (this.getReturnType() == (class$java$lang$String == null ? (class$java$lang$String = MethodTarget.class$("java.lang.String")) : class$java$lang$String)) {
            return (String)result;
        }
        return this.resultAdapter.toString(result);
    }

    public boolean isVoidReturnType() {
        return this.getReturnType() == (class$java$lang$Void == null ? (class$java$lang$Void = MethodTarget.class$("java.lang.Void")) : class$java$lang$Void);
    }

    public String toString() {
        return "MethodTarget[" + this.methodClosure + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

