/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary;

import fit.Parse;
import fit.exception.FitFailureException;
import fitlibrary.ArrayFixture;
import fitlibrary.parse.Cell;
import fitlibrary.parse.Row;
import fitlibrary.parse.Table;
import fitlibrary.valueAdapter.ValueAdapter;
import java.util.ArrayList;
import java.util.List;

public class ToStringArrayFixture
extends ArrayFixture {
    public ToStringArrayFixture(Object[] array) {
        super(array);
    }

    public ToStringArrayFixture(List list) {
        super(list);
    }

    public void doTable(Table table) {
        if (this.actuals == null) {
            throw new FitFailureException("Actual list missing");
        }
        Row row = table.row(0);
        try {
            List bindings = new ArrayList();
            if (!this.actuals.isEmpty()) {
                bindings = this.bindLabelsForAllActuals(row);
            } else if (!table.rowExists(1)) {
                table.row(0).right(this.counts);
            }
            int rowNo = 1;
            while (rowNo < table.size()) {
                row = table.row(rowNo);
                this.processRow(row, bindings);
                ++rowNo;
            }
            this.showSurplus(bindings, table);
        }
        catch (Exception e) {
            row.exception(this, e);
        }
    }

    protected ValueAdapter bindField(String name, Object element) {
        return new ToStringValueAdapter(element);
    }

    static class ToStringValueAdapter
    extends ValueAdapter {
        private Object target;

        public ToStringValueAdapter(Object element) {
            this.setTarget(element);
        }

        public Object parse(Cell cell) throws Exception {
            return cell.text();
        }

        public Object parse(Parse cell) {
            return cell.text();
        }

        public Object get() {
            return this.target.toString();
        }

        public void setTarget(Object element) {
            this.target = element;
        }

        public boolean matches(Cell cell, Object result) throws Exception {
            return this.matches(cell.parse, result);
        }

        public boolean matches(Parse cell, Object result) throws Exception {
            return cell.text().equals(result);
        }

        public String getString() throws Exception {
            return this.target.toString();
        }

        public String toString(Object result) {
            return result.toString();
        }
    }
}

