/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary;

import fit.exception.FitFailureException;
import fit.exception.RowWrongWidthException;
import fitlibrary.DoFixture;
import fitlibrary.ExtendedCamelCase;
import fitlibrary.FitLibraryFixture;
import fitlibrary.FunctionFixture;
import fitlibrary.closure.MethodTarget;
import fitlibrary.parse.Row;
import fitlibrary.parse.Table;
import java.util.ArrayList;
import java.util.List;

public class SetUpFixture
extends FunctionFixture {
    protected MethodTarget target;
    protected int argCount = -1;
    protected boolean boundOK = false;

    public SetUpFixture() {
    }

    public SetUpFixture(Object sut) {
        super(sut);
    }

    public void doTable(Table table) {
        this.doSetUp(table);
        try {
            this.bindFirstRowToTarget(table.row(1));
            int i = 2;
            while (i < table.size()) {
                this.processRow(table.row(i));
                ++i;
            }
            this.internalTearDown();
        }
        catch (Exception e) {
            this.handleException(table, e);
        }
        this.doTearDown(table);
    }

    private void handleException(Table table, Exception e) {
        table.row(0).exception(this, e);
    }

    protected void bindFirstRowToTarget(Row row) {
        this.argCount = row.size();
        String argNames = "";
        ArrayList<String> arguments = new ArrayList<String>();
        int i = 0;
        while (i < this.argCount) {
            String name = row.cell(i).text();
            argNames = argNames + " " + name;
            arguments.add(ExtendedCamelCase.camel(name));
            ++i;
        }
        String methodName = ExtendedCamelCase.camel(argNames);
        try {
            this.target = this.findMethodTarget(arguments, methodName);
            this.boundOK = true;
        }
        catch (Exception e) {
            row.exception(this, e);
        }
    }

    protected MethodTarget findMethodTarget(List arguments, String methodName) {
        return this.findMethod(methodName, arguments, "void");
    }

    protected void processRow(Row row) {
        if (!this.boundOK) {
            row.ignore(this.counts);
            return;
        }
        if (row.size() != this.argCount) {
            row.exception(this, (Throwable)((Object)new RowWrongWidthException(this.argCount)));
            return;
        }
        try {
            this.invokeMethod(row);
        }
        catch (Exception e) {
            row.exception(this, e);
        }
    }

    protected Object invokeMethod(Row row) throws Exception {
        return this.target.invoke(row);
    }

    protected void setUpFinished() {
        FitLibraryFixture outer = this.getOuterContextFixture();
        if (outer == null) {
            throw new FitFailureException("SetUp unable to finish as no outer context.");
        }
        if (!(outer instanceof DoFixture)) {
            throw new FitFailureException("SetUp unable to finish as outer context is not DoFixture.");
        }
        ((DoFixture)outer).finishSettingUp();
    }
}

