/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary;

import fit.exception.ExtraCellsFailureException;
import fit.exception.MissingCellsFailureException;
import fitlibrary.ListFixture;
import fitlibrary.parse.Cell;
import fitlibrary.parse.Row;
import fitlibrary.valueAdapter.ValueAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SetFixture
extends ListFixture {
    public SetFixture() {
    }

    public SetFixture(Iterator actuals) {
        super(actuals);
    }

    public SetFixture(Collection actuals) {
        super(actuals);
    }

    public SetFixture(Object[] actuals) {
        super(actuals);
    }

    public SetFixture(Map map) {
        ArrayList<ListFixture.Element> elements = new ArrayList<ListFixture.Element>();
        Set keySet = map.keySet();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            elements.add(new ListFixture.Element(key, map.get(key)));
        }
        this.setActualCollection(elements);
    }

    protected void processRow(Row row, List actuals) throws Exception {
        ValueAdapter[] columnBindings;
        if (actuals.isEmpty()) {
            row.missing(this.counts);
            return;
        }
        int rowLength = row.size();
        if (rowLength < (columnBindings = (ValueAdapter[])actuals.get(0)).length) {
            throw new MissingCellsFailureException("ArrayFixture");
        }
        if (rowLength > columnBindings.length) {
            throw new ExtraCellsFailureException("ArrayFixture");
        }
        List matchingActuals = actuals;
        int column = 0;
        while (column < columnBindings.length) {
            if ((matchingActuals = this.matchOnColumn(row, matchingActuals, column)).isEmpty()) {
                row.missing(this.counts);
                return;
            }
            if (matchingActuals.size() == 1) {
                ValueAdapter[] theOne = (ValueAdapter[])matchingActuals.get(0);
                this.matchRow(row, theOne);
                actuals.remove(theOne);
                return;
            }
            ++column;
        }
        if (!matchingActuals.isEmpty()) {
            ValueAdapter[] theOne = (ValueAdapter[])matchingActuals.get(0);
            this.matchRow(row, theOne);
            actuals.remove(theOne);
        }
    }

    private List matchOnColumn(Row row, List actuals, int column) {
        Cell cell = row.cell(column);
        ArrayList<ValueAdapter[]> results = new ArrayList<ValueAdapter[]>();
        Iterator it = actuals.iterator();
        while (it.hasNext()) {
            ValueAdapter[] columnBindings = (ValueAdapter[])it.next();
            ValueAdapter adapter = columnBindings[column];
            if (adapter == null) {
                if (!cell.blank()) continue;
                results.add(columnBindings);
                continue;
            }
            try {
                if (!adapter.matches(cell)) continue;
                results.add(columnBindings);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return results;
    }
}

