/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary;

import fit.Fixture;
import fit.Parse;
import fit.exception.FitFailureException;
import fit.exception.MissingFieldFitFailureException;
import fit.exception.NoSuchFieldFitFailureException;
import fitlibrary.ExtendedCamelCase;
import fitlibrary.FitLibraryFixture;
import fitlibrary.parse.Cell;
import fitlibrary.parse.Row;
import fitlibrary.parse.Table;
import fitlibrary.valueAdapter.MapValueAdapter;
import fitlibrary.valueAdapter.ValueAdapter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class ListFixture
extends FitLibraryFixture {
    protected Collection actuals;
    private boolean[] usedField;

    public ListFixture() {
    }

    public ListFixture(Iterator it) {
        this.setActualCollection(it);
    }

    public ListFixture(Collection actuals) {
        this.setActualCollection(actuals);
    }

    public ListFixture(Object[] actuals) {
        this.setActualCollection(actuals);
    }

    public void setActualCollection(Collection actuals) {
        this.actuals = actuals;
    }

    public void setActualCollection(Object[] actuals) {
        this.setActualCollection(Arrays.asList(actuals));
    }

    public void setActualCollection(Iterator it) {
        ArrayList actualCollection = new ArrayList();
        while (it.hasNext()) {
            actualCollection.add(it.next());
        }
        this.setActualCollection(actualCollection);
    }

    public void doTable(Table table) {
        if (this.actuals == null) {
            throw new FitFailureException("Actual list missing");
        }
        Row row = table.row(1);
        try {
            List bindings = new ArrayList();
            if (!this.actuals.isEmpty()) {
                bindings = this.bindLabelsForAllActuals(row);
            } else if (!table.rowExists(2)) {
                table.row(1).right(this.counts);
            }
            int rowNo = 2;
            while (rowNo < table.size()) {
                row = table.row(rowNo);
                this.processRow(row, bindings);
                ++rowNo;
            }
            this.showSurplus(bindings, table);
        }
        catch (Exception e) {
            row.exception(this, e);
        }
    }

    protected abstract void processRow(Row var1, List var2) throws Exception;

    protected void showSurplus(List bindings, Table table) {
        if (!bindings.isEmpty()) {
            this.addSurplusRows(table, bindings);
        }
    }

    protected List bindLabelsForAllActuals(Row row) throws Exception {
        this.usedField = new boolean[row.size()];
        int i = 0;
        while (i < this.usedField.length) {
            this.usedField[i] = false;
            ++i;
        }
        ArrayList<ValueAdapter[]> bindings = new ArrayList<ValueAdapter[]>();
        Iterator it = this.actuals.iterator();
        while (it.hasNext()) {
            bindings.add(this.bindLabelsForOneElement(row, it.next()));
        }
        int i2 = 0;
        while (i2 < this.usedField.length) {
            if (!this.usedField[i2]) {
                throw new MissingFieldFitFailureException(ExtendedCamelCase.camel(row.cell(i2).text()), "ArrayFixture");
            }
            ++i2;
        }
        return bindings;
    }

    protected ValueAdapter[] bindLabelsForOneElement(Row row, Object element) throws Exception {
        ValueAdapter[] columnBindings = new ValueAdapter[row.size()];
        int i = 0;
        while (i < columnBindings.length) {
            String fieldName = ExtendedCamelCase.camel(row.text(i));
            try {
                columnBindings[i] = this.bindField(fieldName, element);
                if (columnBindings[i] != null) {
                    columnBindings[i].setTarget(element);
                    this.usedField[i] = true;
                }
            }
            catch (NoSuchFieldException e) {
                throw new NoSuchFieldFitFailureException(fieldName);
            }
            ++i;
        }
        return columnBindings;
    }

    protected ValueAdapter bindField(String name, Object element) throws Exception {
        if (element instanceof Map) {
            Object value = ((Map)element).get(name);
            if (value == null) {
                return null;
            }
            return new MapValueAdapter(value, this);
        }
        Class<?> targetClass = element.getClass();
        try {
            Field field = targetClass.getField(FitLibraryFixture.extendedCamel(name));
            return ValueAdapter.on((FitLibraryFixture)this, field);
        }
        catch (NoSuchFieldException e) {
            try {
                return this.getMethod(targetClass, "get " + name);
            }
            catch (NoSuchMethodException e1) {
                try {
                    return this.getMethod(targetClass, "is " + name);
                }
                catch (NoSuchMethodException e2) {
                    return null;
                }
            }
        }
    }

    protected ValueAdapter getMethod(Class targetClass, String getterName) throws NoSuchMethodException {
        String extendedCamel = FitLibraryFixture.extendedCamel(getterName);
        return ValueAdapter.onResult(this, targetClass.getMethod(extendedCamel, new Class[0]));
    }

    protected boolean matchRow(Row row, ValueAdapter[] columnBindings) throws Exception {
        boolean matchedAlready = false;
        int i = 0;
        while (i < columnBindings.length) {
            Cell cell = row.cell(i);
            ValueAdapter adapter = columnBindings[i];
            if (adapter == null) {
                if (cell.blank()) {
                    cell.right(this.counts);
                } else {
                    cell.wrong(this.counts, "");
                }
            } else {
                boolean match = adapter.matches(cell);
                if (match) {
                    if (!cell.hasParts()) {
                        cell.right(this.counts);
                    }
                } else if (matchedAlready) {
                    if (!cell.hasParts()) {
                        cell.wrong(this.counts, adapter.getString());
                    }
                } else {
                    return false;
                }
                matchedAlready = true;
            }
            ++i;
        }
        return true;
    }

    protected void addSurplusRows(Table table, List surplusBindings) {
        Iterator it = surplusBindings.iterator();
        while (it.hasNext()) {
            ValueAdapter[] adapter = (ValueAdapter[])it.next();
            Row row = this.buildSurplusRow(this.getValues(adapter));
            row.cell(0).surplus(this.counts);
            table.addRow(row);
        }
    }

    private Row buildSurplusRow(Object[] values) {
        Parse root;
        if (values.length == 0) {
            Parse nil = new Parse("td", "null", null, null);
            nil.addToTag(" colspan=" + values.length);
            return new Row(nil);
        }
        Parse next = root = new Parse(null, null, null, null);
        int i = 0;
        while (i < values.length) {
            next = next.more = new Parse("td", "&nbsp;", null, null);
            Object value = values[i];
            if (value == null) {
                new Cell(next).ignore(this.counts);
            } else if (value instanceof Exception) {
                this.exception(next, (Exception)value);
            } else {
                next.body = this.grayColored(Fixture.escape((String)value.toString()));
            }
            ++i;
        }
        return new Row(new Parse("tr", null, root.more, null));
    }

    private Object[] getValues(ValueAdapter[] adapter) {
        Object[] values = new Object[adapter.length];
        int i = 0;
        while (i < adapter.length) {
            ValueAdapter valueAdapter = adapter[i];
            if (valueAdapter == null) {
                values[i] = null;
            } else {
                try {
                    values[i] = valueAdapter.toString(valueAdapter.get());
                }
                catch (Exception e) {
                    values[i] = e;
                }
            }
            ++i;
        }
        return values;
    }

    public static class Element {
        private Object key;
        private Object value;

        public Element(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

