/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary;

import fit.Parse;
import fitlibrary.FitLibraryFixture;
import fitlibrary.parse.Cell;
import fitlibrary.parse.Row;
import fitlibrary.parse.Table;
import fitlibrary.valueAdapter.ValueAdapter;

public class GridFixture
extends FitLibraryFixture {
    private Object[][] grid;
    private ValueAdapter valueAdapter;

    public GridFixture(Object[][] grid) {
        this.setGrid(grid);
    }

    protected GridFixture() {
    }

    public void setGrid(Object[][] grid) {
        this.grid = grid;
        this.valueAdapter = ValueAdapter.on((FitLibraryFixture)this, grid.getClass().getComponentType().getComponentType());
    }

    public void doTable(Table table) {
        if (this.grid.length == 0 && table.size() == 1) {
            table.right(this.counts);
        } else if (!this.rowsMatch(this.grid, table)) {
            this.addActualRows(table, this.grid);
        }
    }

    private boolean rowsMatch(Object[][] actual, Table table) {
        boolean matched = true;
        int rowNo = 0;
        while (rowNo < actual.length) {
            if (!table.rowExists(rowNo + 1)) {
                return false;
            }
            Row row = table.row(rowNo + 1);
            if (!this.cellsMatch(actual[rowNo], row)) {
                matched = false;
            }
            ++rowNo;
        }
        int rowNo2 = actual.length + 1;
        while (rowNo2 < table.size()) {
            matched = false;
            table.row(rowNo2).wrong(this.counts);
            ++rowNo2;
        }
        return matched;
    }

    private boolean cellsMatch(Object[] actual, Row row) {
        Parse cells = row.parse.parts;
        boolean matched = true;
        int i = 0;
        while (i < actual.length) {
            if (!row.cellExists(i)) {
                return false;
            }
            if (!this.cellMatches(actual[i], row.cell(i))) {
                matched = false;
            }
            cells = cells.more;
            ++i;
        }
        int cellNo = actual.length;
        while (cellNo < row.size()) {
            matched = false;
            row.cell(cellNo).wrong(this.counts);
            ++cellNo;
        }
        return matched;
    }

    private boolean cellMatches(Object actual, Cell cell) {
        boolean matches = false;
        try {
            matches = this.valueAdapter.matches(cell, actual);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (matches) {
            cell.right(this.counts);
        } else {
            cell.wrong(this.counts);
        }
        return matches;
    }

    private void addActualRows(Table table, Object[][] actual) {
        this.addActualRows(table.parse.parts, actual);
    }

    private void addActualRows(Parse rows, Object[][] actual) {
        int cols = 0;
        Parse lastRow = rows;
        while (rows != null) {
            lastRow = rows;
            cols = Math.max(cols, lastRow.size());
            rows = rows.more;
        }
        int i = 0;
        while (i < actual.length) {
            cols = Math.max(cols, actual[i].length);
            ++i;
        }
        lastRow = lastRow.more = new Parse("tr", null, new Parse("td colspan=" + cols, "<i>Actuals:</i>", null, null), null);
        int i2 = 0;
        while (i2 < actual.length) {
            lastRow = lastRow.more = this.makeRowWithTr(actual[i2]);
            ++i2;
        }
    }

    private Parse makeRowWithTr(Object[] actuals) {
        return new Parse("tr", null, this.makeCellsWithTd(actuals), null);
    }

    private Parse makeCellsWithTd(Object[] actuals) {
        Parse rows;
        if (actuals.length == 0) {
            throw new RuntimeException("Actuals row empty");
        }
        Parse row = rows = this.makeCell(actuals[0]);
        int i = 1;
        while (i < actuals.length) {
            row = row.more = this.makeCell(actuals[i]);
            ++i;
        }
        return rows;
    }

    private Parse makeCell(Object object) {
        String toString;
        try {
            toString = this.valueAdapter.toString(object);
        }
        catch (Exception e) {
            toString = e.toString();
        }
        return new Parse("td", this.grayColored(toString), null, null);
    }
}

