/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary;

import fit.Counts;
import fit.Fixture;
import fit.Parse;
import fitlibrary.FitLibraryFixture;
import fitlibrary.parse.Row;
import fitlibrary.parse.Table;
import fitlibrary.parse.Tables;
import fitlibrary.valueAdapter.ValueAdapter;

public abstract class FlowFixture
extends FitLibraryFixture {
    private boolean abandon = false;
    private boolean stopOnError = false;
    private boolean passedOntoOtherFixture = false;
    protected boolean flowFixtureObject = false;
    private boolean passFromSuiteToFlowFixtureObject = false;

    public void interpretTables(Parse tables) {
        this.interpretTables(new Tables(tables));
    }

    public void interpretTables(Tables tables) {
        this.abandon = false;
        this.stopOnError = false;
        this.passedOntoOtherFixture = false;
        this.passFromSuiteToFlowFixtureObject = false;
        this.flowFixtureObject = true;
        Table firstTable = tables.table(0);
        try {
            this.setUp();
        }
        catch (Exception e) {
            firstTable.exception(this, e);
        }
        if (firstTable.size() > 1) {
            this.doTable(firstTable.parse);
        }
        firstTable.finished(this.listener);
        int tableNo = 1;
        while (tableNo < tables.size() && this.keepGoing()) {
            Table table = tables.table(tableNo);
            this.interpretTable(table);
            if (this.abandon || this.stopOnError && this.problem(this.counts)) {
                table.ignore(this.counts);
            }
            ++tableNo;
        }
        ValueAdapter.clearDelegatesForNextTest();
        try {
            this.tearDown();
        }
        catch (Exception e) {
            firstTable.exception(this, e);
        }
    }

    protected void interpretTable(Table table) {
        try {
            Fixture fixtureByName = this.fixtureByName(table);
            Object result = this.interpretRow(table.row(0), fixtureByName);
            if (result instanceof Fixture) {
                this.interpretTableWithFixture(table, (Fixture)result);
            } else {
                this.doTable(table.parse);
            }
        }
        catch (Throwable e) {
            table.exception(this, e);
        }
        table.finished(this.listener);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    protected boolean keepGoing() {
        return !this.abandon && !this.passFromSuiteToFlowFixtureObject && (!this.stopOnError || !this.problem(this.counts));
    }

    protected Fixture fixtureByName(Table table) {
        if (table.row(0).text(0).trim().equals("")) {
            return null;
        }
        try {
            return this.getLinkedFixtureWithArgs(table.parse);
        }
        catch (Throwable e) {
            return null;
        }
    }

    protected void interpretTableWithFixture(Table table, Fixture fixture) {
        fixture.counts = this.counts;
        fixture.summary = this.summary;
        fixture.doTable(table.parse);
    }

    public void doTable(Parse table) {
        this.doTable(new Table(table));
    }

    public void doTable(Table table) {
        this.doSetUp(table);
        this.passedOntoOtherFixture = false;
        int size = table.size();
        int rowNo = 1;
        while (rowNo < size && !this.passedOntoOtherFixture) {
            this.runRow(table.row(rowNo));
            ++rowNo;
        }
        this.doTearDown(table);
    }

    protected void doSetUp(Table table) {
        try {
            if (!this.flowFixtureObject) {
                this.setUp();
            }
        }
        catch (Exception e) {
            table.exception(this, e);
        }
    }

    protected void doTearDown(Table table) {
        try {
            if (!this.flowFixtureObject) {
                this.tearDown();
            }
        }
        catch (Exception e) {
            table.exception(this, e);
        }
    }

    private void runRow(Row row) {
        try {
            Object result = this.interpretRow(row, null);
            if (result instanceof Fixture) {
                Parse restOfTable = new Parse("table", "", row.parse, null);
                this.interpretTableWithFixture(new Table(restOfTable), (Fixture)result);
                this.passedOntoOtherFixture = true;
            }
        }
        catch (Exception ex) {
            row.exception(this, ex);
        }
    }

    public boolean isStopOnError() {
        return this.stopOnError;
    }

    public void setStopOnError(boolean stopOnError) {
        this.stopOnError = stopOnError;
    }

    public void abandonStorytest(Parse cells) {
        this.abandon = true;
    }

    protected void passOverStorytest() {
        this.passFromSuiteToFlowFixtureObject = true;
    }

    private boolean problem(Counts official) {
        return official.wrong + official.exceptions > 0;
    }

    protected abstract Object interpretRow(Row var1, Fixture var2);
}

