/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary;

import fit.Fixture;
import fit.Parse;
import fit.exception.CycleException;
import fit.exception.FitFailureException;
import fitlibrary.DoFixture;
import fitlibrary.ExtendedCamelCase;
import fitlibrary.closure.MethodClosure;
import fitlibrary.differences.DifferenceInterface;
import fitlibrary.differences.FitNesseDifference;
import fitlibrary.differences.FolderRunnerDifference;
import fitlibrary.differences.LocalFile;
import fitlibrary.parse.Table;
import fitlibrary.valueAdapter.ValueAdapter;
import java.io.File;

public abstract class FitLibraryFixture
extends Fixture {
    protected static DifferenceInterface FITNESSE_DIFFERENCES = new FitNesseDifference();
    private FitLibraryFixture outerContextFixture = null;
    protected Object systemUnderTest = null;
    static /* synthetic */ Class class$java$lang$String;

    public static void setFolderRunnerStrategy() {
        FITNESSE_DIFFERENCES = new FolderRunnerDifference();
    }

    protected void registerParseDelegate(Class type, Class parseDelegate) {
        ValueAdapter.registerParseDelegate(type, parseDelegate);
    }

    protected void registerParseDelegate(Class type, Object parseDelegate) {
        ValueAdapter.registerParseDelegate(type, parseDelegate);
    }

    public Object parse(String s, Class type) throws Exception {
        if (type.equals(class$java$lang$String == null ? (class$java$lang$String = FitLibraryFixture.class$("java.lang.String")) : class$java$lang$String)) {
            return s;
        }
        return super.parse(s, type);
    }

    public static String extendedCamel(String name) {
        return ExtendedCamelCase.camel(name);
    }

    public void exception(Parse cell, String message) {
        this.exception(cell, (Throwable)new FitFailureException(message));
    }

    public void rightHtml(Parse cell, String actual) {
        this.right(cell);
        cell.body = actual;
    }

    public void wrongHtml(Parse cell, String actual) {
        this.wrong(cell);
        cell.addToBody(Fixture.label((String)"expected") + "<hr>" + actual + Fixture.label((String)"actual"));
    }

    public static String replaceString(String text, String pattern, String replacement) {
        int pos = 0;
        while ((pos = text.indexOf(pattern, pos)) >= 0) {
            text = text.substring(0, pos) + replacement + text.substring(pos + pattern.length());
            pos += replacement.length();
        }
        return text;
    }

    public static File getRelativeFile(String name) {
        return FitLibraryFixture.getLocalFile(name).getFile();
    }

    public static LocalFile getLocalFile(String localFileName) {
        return FITNESSE_DIFFERENCES.getLocalFile(localFileName);
    }

    protected static String htmlLink(File file) {
        LocalFile localFile = FITNESSE_DIFFERENCES.getGlobalFile(file);
        return localFile.htmlLink();
    }

    public String grayColored(String string) {
        return Fixture.gray((String)string);
    }

    public void setSystemUnderTest(Object sut) {
        if (this.cycleSUT(this, sut)) {
            throw new CycleException("systemUnderTest", (Object)this, sut);
        }
        this.systemUnderTest = sut;
    }

    private boolean cycleSUT(FitLibraryFixture fixture, Object sut) {
        if (fixture == sut) {
            return true;
        }
        if (sut instanceof DoFixture) {
            return this.cycleSUT(fixture, ((DoFixture)((Object)sut)).systemUnderTest);
        }
        return false;
    }

    public Object getSystemUnderTest() {
        return this.systemUnderTest;
    }

    public void setOuterContext(FitLibraryFixture fixture) {
        if (this.cycleOC(this, fixture)) {
            throw new CycleException("outerContext", (Object)this, (Object)fixture);
        }
        this.outerContextFixture = fixture;
    }

    private boolean cycleOC(FitLibraryFixture fixture, FitLibraryFixture oc) {
        if (fixture == oc) {
            return true;
        }
        if (oc instanceof DoFixture) {
            return this.cycleOC(fixture, oc.outerContextFixture);
        }
        return false;
    }

    public FitLibraryFixture getOuterContextFixture() {
        return this.outerContextFixture;
    }

    public MethodClosure findEntityMethod(String name, Class[] args) {
        MethodClosure method = MethodClosure.findSpecificMethod((Object)this, name, args);
        if (method == null && this.systemUnderTest != null) {
            method = MethodClosure.findSpecificMethod(this.systemUnderTest, name, args);
        }
        if (method == null && this.outerContextFixture != null) {
            method = MethodClosure.findSpecificMethod((Object)this.outerContextFixture, name, args);
        }
        return method;
    }

    public static void setContext(File reportDiry) {
        FITNESSE_DIFFERENCES.setContext(reportDiry);
    }

    public void doTable(Parse table) {
        this.doTable(new Table(table));
    }

    public abstract void doTable(Table var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

