/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary;

import fit.Fixture;
import java.util.HashSet;
import java.util.Set;

public class ExtendedCamelCase {
    static final String[] map = new String[]{"!", " bang ", "\"", " quote ", "#", " hash ", "$", " dollar ", "%", " percent ", "&", " ampersand ", "'", " single quote ", "(", " left parenthesis ", ")", " right parenthesis ", "*", " star ", "+", " plus ", ",", " comma ", "-", " minus ", ".", " dot ", "/", " slash ", ":", " colon ", ";", " semicolon ", "<", " less than ", ">", " greater than ", "=", " equals ", "?", " question ", "@", " at ", "[", " left square bracket ", "]", " right square bracket ", "\\", " backslash ", "^", " caret ", "`", " backquote ", "{", " left brace ", "}", " right brace ", "|", " bar ", "~", " tilde "};
    private static final String[] javaKeyWords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    private static final Set javaKeywordSet = new HashSet();

    public static String camel(String name) {
        if ((name = name.trim()).length() == 0) {
            return "blank";
        }
        int i = 0;
        while (i < map.length) {
            int pos;
            String from = map[i];
            String to = map[i + 1];
            while ((pos = name.indexOf(from)) >= 0) {
                name = name.substring(0, pos) + to + name.substring(pos + from.length());
            }
            i += 2;
        }
        if (Character.isDigit(name.charAt(0))) {
            name = ExtendedCamelCase.mapNumber(name.charAt(0)) + name.substring(1);
        }
        if (Character.isUpperCase(name.charAt(0))) {
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        }
        return ExtendedCamelCase.hideJavaKeyword(ExtendedCamelCase.translateUnicode(Fixture.camel((String)name)));
    }

    private static String hideJavaKeyword(String name) {
        if (javaKeywordSet.contains(name)) {
            return name + "_";
        }
        return name;
    }

    private static String translateUnicode(String name) {
        StringBuffer b = new StringBuffer(name.length());
        int i = 0;
        while (i < name.length()) {
            char ch = name.charAt(i);
            if (ch < '\u0080') {
                b.append(ch);
            } else {
                b.append("u" + Integer.toHexString(ch).toUpperCase());
            }
            ++i;
        }
        name = b.toString();
        return name;
    }

    private static String mapNumber(char c) {
        switch (c) {
            case '0': {
                return "zero ";
            }
            case '1': {
                return "one ";
            }
            case '2': {
                return "two ";
            }
            case '3': {
                return "three ";
            }
            case '4': {
                return "four ";
            }
            case '5': {
                return "five ";
            }
            case '6': {
                return "six ";
            }
            case '7': {
                return "seven ";
            }
            case '8': {
                return "eight ";
            }
            case '9': {
                return "nine ";
            }
        }
        return "" + c;
    }

    static {
        int i = 0;
        while (i < javaKeyWords.length) {
            javaKeywordSet.add(javaKeyWords[i]);
            ++i;
        }
    }
}

