/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary;

import fit.Fixture;
import fit.Parse;
import fit.exception.AmbiguousActionException;
import fit.exception.ExtraCellsFailureException;
import fit.exception.FitFailureException;
import fit.exception.FitFailureExceptionWithHelp;
import fit.exception.IgnoredException;
import fit.exception.MissingCellsFailureException;
import fit.exception.MissingMethodException;
import fitlibrary.CalculateFixture;
import fitlibrary.CommentFixture;
import fitlibrary.ExtendedCamelCase;
import fitlibrary.FlowFixture;
import fitlibrary.SetUpFixture;
import fitlibrary.closure.MethodClosure;
import fitlibrary.closure.MethodTarget;
import fitlibrary.graphic.GraphicValueAdapter;
import fitlibrary.graphic.ObjectDotGraphic;
import fitlibrary.log.Logging;
import fitlibrary.parse.Row;
import fitlibrary.valueAdapter.ValueAdapter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DoFixture
extends FlowFixture {
    protected Map map = new HashMap();
    private boolean gatherExpectedForGeneration = false;
    protected Object expectedResult = new Boolean(true);
    private SetUpFixture setUpFixture = null;
    private boolean settingUp = true;
    static /* synthetic */ Class class$fitlibrary$graphic$ObjectDotGraphic;
    static /* synthetic */ Class class$fit$Parse;

    public DoFixture() {
    }

    public DoFixture(Object sut) {
        this.setSystemUnderTest(sut);
    }

    public void check(Parse cells) throws Exception {
        cells = cells.more;
        if (cells == null) {
            throw new MissingCellsFailureException("DoFixtureCheck");
        }
        int argCount = cells.size() - 2;
        Parse expectedCell = cells.at(argCount + 1);
        MethodTarget target = this.findMethodByActionName(cells, argCount);
        if (this.gatherExpectedForGeneration) {
            this.expectedResult = target.getResult(expectedCell);
        }
        target.invokeAndCheck(cells.more, expectedCell);
    }

    protected Object getExpectedResult() {
        return this.expectedResult;
    }

    public void reject(Parse cells) throws Exception {
        this.not(cells);
    }

    public void not(Parse cells) throws Exception {
        block6: {
            Parse notCell = cells;
            cells = cells.more;
            if (cells == null) {
                throw new MissingCellsFailureException("DoFixtureNot");
            }
            this.expectedResult = new Boolean(false);
            MethodTarget target = this.findMethodByActionName(cells, cells.size() - 1);
            try {
                Object result = this.callGivenMethod(target, cells);
                if (!(result instanceof Boolean)) {
                    this.exception(notCell, "Was not rejected");
                    break block6;
                }
                if (((Boolean)result).booleanValue()) {
                    this.wrong(notCell);
                    break block6;
                }
                this.right(notCell);
            }
            catch (IgnoredException e) {
            }
            catch (Exception e) {
                this.right(notCell);
            }
        }
    }

    public void show(Parse cells) throws Exception {
        cells = cells.more;
        if (cells == null) {
            throw new MissingCellsFailureException("DoFixtureShow");
        }
        int argCount = cells.size() - 1;
        MethodTarget target = this.findMethodByActionName(cells, argCount);
        try {
            Object result = this.callGivenMethod(target, cells);
            this.addCell(cells, target.getResultString(result));
        }
        catch (IgnoredException e) {}
    }

    public void showDot(Parse cells) throws Exception {
        cells = cells.more;
        if (cells == null) {
            throw new MissingCellsFailureException("DoFixtureShowDot");
        }
        int argCount = cells.size() - 1;
        MethodTarget target = this.findMethodByActionName(cells, argCount);
        GraphicValueAdapter adapter = new GraphicValueAdapter(class$fitlibrary$graphic$ObjectDotGraphic == null ? (class$fitlibrary$graphic$ObjectDotGraphic = DoFixture.class$("fitlibrary.graphic.ObjectDotGraphic")) : class$fitlibrary$graphic$ObjectDotGraphic, null, null);
        try {
            Object result = this.callGivenMethod(target, cells);
            this.addCell(cells, ((ValueAdapter)adapter).toString(new ObjectDotGraphic(result)));
        }
        catch (IgnoredException e) {}
    }

    private void addCell(Parse cells, Object result) {
        cells.last().more = new Parse("td", result.toString(), null, null);
    }

    public void ensure(Parse cells) throws Exception {
        block5: {
            Parse ensureCell = cells;
            cells = cells.more;
            if (cells == null) {
                throw new MissingCellsFailureException("DoFixtureEnsure");
            }
            this.expectedResult = new Boolean(true);
            MethodTarget target = this.findMethodByActionName(cells, cells.size() - 1);
            try {
                Object result = this.callGivenMethod(target, cells);
                if (((Boolean)result).booleanValue()) {
                    this.right(ensureCell);
                    break block5;
                }
                this.wrong(ensureCell);
            }
            catch (IgnoredException e) {
            }
            catch (Exception e) {
                this.wrong(ensureCell);
            }
        }
    }

    public void note(Parse cells) throws Exception {
    }

    public CommentFixture comment(Parse cells) {
        return new CommentFixture();
    }

    public Fixture ignored(Parse cells) {
        return new Fixture();
    }

    public void name(Parse cells) throws Exception {
        cells = cells.more;
        if (cells == null || cells.more == null) {
            throw new MissingCellsFailureException("DoFixtureName");
        }
        String name = cells.text();
        Parse methodCells = cells.more;
        int argCount = methodCells.size() - 1;
        MethodTarget target = this.findMethodByActionName(methodCells, argCount);
        Object result = target.invokeAndWrap(methodCells.more);
        if (!(result instanceof Fixture)) {
            throw new FitFailureException("Must return an object.");
        }
        this.map.put(name, result);
        this.right(cells);
    }

    public Fixture use(Parse cells) {
        cells = cells.more;
        if (cells == null) {
            throw new MissingCellsFailureException("DoFixtureUse");
        }
        String name = cells.text();
        Object object = this.getMapper((Parse)cells.more).map.get(name);
        if (object instanceof Fixture) {
            return (Fixture)object;
        }
        throw new FitFailureException("Unknown name: " + name);
    }

    private DoFixture getMapper(Parse cells) {
        if (cells == null) {
            return this;
        }
        if (!cells.text().equals("of")) {
            throw new FitFailureException("Missing 'of'.");
        }
        if (cells.more != null) {
            cells = cells.more;
            String name = cells.text();
            Object object = this.getMapper((Parse)cells.more).map.get(name);
            if (object instanceof DoFixture) {
                return (DoFixture)((Object)object);
            }
            throw new FitFailureException("Unknown name: " + name);
        }
        throw new FitFailureException("Missing name.");
    }

    public void start(Parse cells) {
        cells = cells.more;
        if (cells == null) {
            throw new MissingCellsFailureException("DoFixtureStart");
        }
        if (cells.more != null) {
            throw new ExtraCellsFailureException("DoFixtureStart");
        }
        String className = cells.text();
        try {
            this.setSystemUnderTest(Class.forName(className).newInstance());
        }
        catch (Exception e) {
            throw new FitFailureExceptionWithHelp("Unknown class: " + className, "UnknownClass.DoFixtureStart");
        }
    }

    public Fixture calculate(Parse cells) {
        if (this.systemUnderTest == null) {
            return new CalculateFixture((Object)this);
        }
        return new CalculateFixture(this.systemUnderTest);
    }

    protected Object interpretRow(Row row, Fixture namedFixture) {
        return this.interpretCells(row.parse.parts, namedFixture);
    }

    protected Object interpretCells(Parse cells, Fixture namedFixture) {
        this.expectedResult = new Boolean(true);
        String methodName = cells.text();
        try {
            Method parseMethod = this.switchSetUp().parseMethod(cells);
            this.checkForAmbiguity(methodName, namedFixture, parseMethod, null);
            try {
                MethodTarget target = this.switchSetUp().findMethodByActionName(cells, cells.size() - 1);
                this.checkForAmbiguity(methodName, namedFixture, parseMethod, target);
                Object result = target.invokeAndWrap(cells.more);
                if (result instanceof Boolean) {
                    target.color(cells, (Boolean)result);
                }
                return result;
            }
            catch (MissingMethodException e) {
                if (parseMethod == null && namedFixture == null) {
                    throw e;
                }
                if (namedFixture != null) {
                    return namedFixture;
                }
                return this.switchSetUp().callParseMethod(parseMethod, cells);
            }
        }
        catch (IgnoredException ex) {
        }
        catch (Exception ex) {
            this.exception(cells, ex);
        }
        return null;
    }

    protected void checkForAmbiguity(String methodName, Fixture namedFixture, Method parseMethod, MethodTarget target) {
        String methodDetails = "method " + methodName + "()";
        String parseMethodDetails = "method " + methodName + "(Parse)";
        String fixtureDetails = methodName + "-Fixture";
        if (target != null && parseMethod != null) {
            throw new AmbiguousActionException(methodDetails, parseMethodDetails);
        }
        if (target != null && namedFixture != null) {
            throw new AmbiguousActionException(methodDetails, fixtureDetails);
        }
        if (parseMethod != null && namedFixture != null) {
            throw new AmbiguousActionException(parseMethodDetails, fixtureDetails);
        }
    }

    private DoFixture switchSetUp() {
        if (this.settingUp && this.setUpFixture != null) {
            return this.setUpFixture;
        }
        return this;
    }

    protected Object calledParseMethod(Parse cells) throws Exception {
        try {
            String name = cells.text().trim();
            if (name.equals("")) {
                return null;
            }
            name = Fixture.camel((String)name);
            Method parseMethod = ((Object)((Object)this)).getClass().getMethod(name, class$fit$Parse == null ? (class$fit$Parse = DoFixture.class$("fit.Parse")) : class$fit$Parse);
            MethodClosure closure = new MethodClosure((Object)this, parseMethod);
            MethodTarget target = new MethodTarget(closure, this);
            Object result = target.invoke(new Object[]{cells});
            if (result == null) {
                result = "";
            }
            return result;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    protected Method parseMethod(Parse cells) {
        try {
            String name = cells.text().trim();
            if (name.equals("")) {
                return null;
            }
            return ((Object)((Object)this)).getClass().getMethod(Fixture.camel((String)name), class$fit$Parse == null ? (class$fit$Parse = DoFixture.class$("fit.Parse")) : class$fit$Parse);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    protected Object callParseMethod(Method parseMethod, Parse cells) throws Exception {
        MethodClosure closure = new MethodClosure((Object)this, parseMethod);
        MethodTarget target = new MethodTarget(closure, this);
        return target.invoke(new Object[]{cells});
    }

    protected MethodTarget findMethodByActionName(Parse cells, int allArgs) throws Exception {
        int parms = allArgs / 2 + 1;
        int argCount = (allArgs + 1) / 2;
        String name = cells.text();
        int i = 1;
        while (i < parms) {
            name = name + " " + cells.at(i * 2).text();
            ++i;
        }
        MethodTarget target = this.findMethod(ExtendedCamelCase.camel(name), argCount);
        target.setEverySecond(true);
        return target;
    }

    protected MethodTarget findMethod(String name, int argCount) {
        String[] args = new String[argCount];
        int i = 0;
        while (i < argCount) {
            args[i] = "arg" + (i + 1);
            ++i;
        }
        return this.findMethod(name, args, "TypeOfResult");
    }

    protected MethodTarget findMethod(String name, List args) {
        return this.findMethod(name, args, "TypeOfResult");
    }

    protected MethodTarget findMethod(String name, List args, String returnType) {
        String[] arguments = new String[args.size()];
        int i = 0;
        while (i < arguments.length) {
            arguments[i] = (String)args.get(i);
            ++i;
        }
        return this.findMethod(name, arguments, returnType);
    }

    private MethodTarget findMethod(String name, String[] args, String returnType) {
        String signature = "";
        if (args.length == 0) {
            signature = "public " + returnType + " get" + name.substring(0, 1).toUpperCase() + name.substring(1) + "() { } OR: ";
        }
        signature = signature + "public " + returnType + " " + name + "(";
        int i = 0;
        while (i < args.length) {
            if (i > 0) {
                signature = signature + ", ";
            }
            signature = signature + "Type" + (i + 1) + " " + args[i];
            ++i;
        }
        return this.findMethod(name, args.length, signature + ") { }");
    }

    private MethodTarget findMethod(String name, int argCount, String signature) {
        MethodTarget result = MethodTarget.findSpecificMethod(name, argCount, (Object)this, this);
        if (result != null) {
            return result;
        }
        Object target = this.systemUnderTest;
        while (target != null) {
            result = MethodTarget.findSpecificMethod(name, argCount, target, this);
            if (result != null) {
                return result;
            }
            target = target instanceof DoFixture ? ((DoFixture)((Object)target)).systemUnderTest : null;
        }
        throw new MissingMethodException((Object)this, signature, "DoFixture");
    }

    protected Object callGivenMethod(MethodTarget target, Parse rowCells) throws Exception {
        return target.invoke(rowCells.more);
    }

    protected void internalTearDown() throws Exception {
        this.systemUnderTest = null;
    }

    protected void setGatherExpectedForGeneration(boolean gatherExpectedForGeneration) {
        this.gatherExpectedForGeneration = gatherExpectedForGeneration;
    }

    public void setSetUpFixture(SetUpFixture setUpFixture) {
        this.setUpFixture = setUpFixture;
        setUpFixture.setOuterContext(this);
    }

    void finishSettingUp() {
        Logging.log("Finish setting up class " + ((Object)((Object)this)).getClass().getName());
        this.settingUp = false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

