/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary;

import fit.exception.BooleanMethodFitFailureException;
import fit.exception.RowWrongWidthException;
import fitlibrary.ExtendedCamelCase;
import fitlibrary.FunctionFixture;
import fitlibrary.closure.MethodTarget;
import fitlibrary.parse.Row;

public class ConstraintFixture
extends FunctionFixture {
    private MethodTarget target;
    private boolean expected = true;
    protected boolean methodOK = false;
    protected int argCount = -1;
    protected boolean boundOK = false;

    public ConstraintFixture() {
    }

    public ConstraintFixture(Object sut) {
        super(sut);
    }

    public ConstraintFixture(boolean expected) {
        this.expected = expected;
    }

    public ConstraintFixture(Object sut, boolean expected) {
        super(sut);
        this.expected = expected;
    }

    protected void bindFirstRowToTarget(Row row) {
        this.argCount = row.size();
        String argNames = "";
        int i = 0;
        while (i < this.argCount) {
            argNames = argNames + row.text(i) + " ";
            ++i;
        }
        try {
            String methodName = ExtendedCamelCase.camel(argNames);
            this.target = this.findMethod(methodName, this.argCount);
            if (this.target.getReturnType() != Boolean.TYPE) {
                throw new BooleanMethodFitFailureException(methodName);
            }
            this.target.setRepeatAndExceptionString(this.repeatString, this.exceptionString);
            this.methodOK = true;
        }
        catch (Exception e) {
            row.exception(this, e);
            return;
        }
    }

    protected void processRow(Row theRow) {
        block5: {
            if (!this.methodOK) {
                theRow.ignore(this.counts);
                return;
            }
            if (theRow.size() != this.argCount) {
                theRow.exception(this, (Throwable)((Object)new RowWrongWidthException(this.argCount)));
                return;
            }
            try {
                boolean result = (Boolean)this.target.invoke(theRow);
                if (result == this.expected) {
                    theRow.right(this.counts);
                    break block5;
                }
                theRow.wrong(this.counts);
            }
            catch (Exception e) {
                theRow.exception(this, e);
            }
        }
    }
}

