/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary;

import fitlibrary.DoFixture;
import fitlibrary.FitLibraryFixture;
import fitlibrary.tree.ListTree;
import fitlibrary.tree.Tree;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class CompareFilesFixture
extends DoFixture {
    public static final ListTree OK = new ListTree("OK");

    public ListTree directorySameAs(String diryName1, String diryName2) throws IOException {
        return this.folderSameAs(diryName1, diryName2);
    }

    public ListTree folderSameAs(String diryName1, String diryName2) throws IOException {
        return this.dirySameAs(FitLibraryFixture.getRelativeFile(diryName1), FitLibraryFixture.getRelativeFile(diryName2));
    }

    public ListTree fileSameAs(String fileName1, String fileName2) throws IOException {
        return this.filesSameAs(FitLibraryFixture.getRelativeFile(fileName1), FitLibraryFixture.getRelativeFile(fileName2));
    }

    public ListTree filesSameAs(File file1, File file2) throws IOException {
        if (file1.isDirectory()) {
            if (file2.isDirectory()) {
                return this.dirySameAs(file1, file2);
            }
            return this.error(file1, "One is a folder");
        }
        return this.filesSame(file1, file2);
    }

    private ListTree dirySameAs(File diry1, File diry2) throws IOException {
        if (!diry1.isDirectory() && !diry2.isDirectory()) {
            return this.filesSameAs(diry1, diry2);
        }
        if (!diry1.isDirectory()) {
            return this.error(diry1, "Must be a folder");
        }
        if (!diry2.isDirectory()) {
            return this.error(diry2, "Must be a folder");
        }
        return this.dirySame(diry1, diry2);
    }

    private ListTree dirySame(File diry1, File diry2) throws IOException {
        ArrayList<ListTree> children = new ArrayList<ListTree>();
        File[] files2 = diry2.listFiles();
        HashMap<String, File> fileMap = new HashMap<String, File>();
        int i = 0;
        while (i < files2.length) {
            File f2 = files2[i];
            fileMap.put(f2.getName(), f2);
            ++i;
        }
        Object[] files1 = diry1.listFiles();
        Arrays.sort(files1);
        int i2 = 0;
        while (i2 < files1.length) {
            Object f1 = files1[i2];
            File f2 = (File)fileMap.get(((File)f1).getName());
            if (f2 == null) {
                if (((File)f1).isDirectory()) {
                    children.add(this.error((File)f1, "Missing folder"));
                } else {
                    children.add(this.error((File)f1, "Missing"));
                }
            } else if (((File)f1).isDirectory() && f2.isDirectory()) {
                children.add(this.dirySame((File)f1, f2));
            } else if (!((File)f1).isDirectory() && !f2.isDirectory()) {
                ListTree filesSameAs = this.filesSameAs((File)f1, f2);
                if (filesSameAs == OK) {
                    children.add(new ListTree(FitLibraryFixture.htmlLink((File)f1)));
                } else {
                    children.add(filesSameAs);
                }
            } else {
                children.add(this.error((File)f1, f2, "Can't compare a folder with a file"));
            }
            if (f2 != null) {
                fileMap.remove(f2.getName());
            }
            ++i2;
        }
        Iterator it = fileMap.keySet().iterator();
        while (it.hasNext()) {
            File f = (File)fileMap.get(it.next());
            if (f.isDirectory()) {
                children.add(this.error(f, "Surplus folder"));
                continue;
            }
            children.add(this.error(f, "Surplus"));
        }
        Iterator it2 = children.iterator();
        while (it2.hasNext()) {
            if (!(it2.next() instanceof ListTreeError)) continue;
            return new ListTreeError(FitLibraryFixture.htmlLink(diry1), children);
        }
        return new ListTree(FitLibraryFixture.htmlLink(diry1));
    }

    private ListTree filesSame(File file1, File file2) throws IOException {
        if (!file1.exists()) {
            return this.error(file1, "File doesn't exist");
        }
        if (!file2.exists()) {
            return this.error(file2, "File doesn't exist");
        }
        if (!file1.canRead()) {
            return this.error(file1, "File may be locked");
        }
        if (!file2.canRead()) {
            return this.error(file2, "File may be locked");
        }
        long lengthDifference = file2.length() - file1.length();
        if (lengthDifference > 0L) {
            return this.error(file1, file2, "File shorter by " + lengthDifference + " bytes than:");
        }
        if (lengthDifference < 0L) {
            return this.error(file1, file2, "File longer by " + -lengthDifference + " bytes than:");
        }
        return this.compareFiles(file1, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ListTree compareFiles(File file1, File file2) throws IOException {
        BufferedReader reader2;
        BufferedReader reader1;
        block5: {
            ListTree listTree;
            block4: {
                reader1 = new BufferedReader(new InputStreamReader(new FileInputStream(file1)));
                reader2 = new BufferedReader(new InputStreamReader(new FileInputStream(file2)));
                int byteNo = 0;
                try {
                    int read1;
                    while ((read1 = reader1.read()) >= 0) {
                        if (read1 != reader2.read()) {
                            listTree = this.error(file1, file2, "Files differ at byte position " + byteNo);
                            Object var9_8 = null;
                            break block4;
                        }
                        ++byteNo;
                    }
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    reader1.close();
                    reader2.close();
                    throw throwable;
                }
            }
            reader1.close();
            reader2.close();
            return listTree;
        }
        Object var9_9 = null;
        reader1.close();
        reader2.close();
        return OK;
    }

    private ListTree error(File file, String errorMessage) {
        return new ListTreeError(FitLibraryFixture.htmlLink(file), new Tree[]{new ListTree("<i>" + errorMessage + "</i>")});
    }

    private ListTree error(File file1, File file2, String errorMessage) {
        ListTree error = this.error(file1, errorMessage);
        error.addChild(new ListTree(FitLibraryFixture.htmlLink(file2)));
        return error;
    }

    public static boolean failingTree(ListTree tree) {
        return tree instanceof ListTreeError;
    }

    private static class ListTreeError
    extends ListTree {
        public ListTreeError(String message, Tree[] trees) {
            super(message, trees);
        }

        public ListTreeError(String name, List children) {
            super(name, children);
        }
    }
}

