/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary;

import fit.exception.ExtraCellsFailureException;
import fit.exception.MissingCellsFailureException;
import fitlibrary.FitLibraryFixture;
import fitlibrary.FunctionFixture;
import fitlibrary.closure.MethodTarget;
import fitlibrary.parse.Cell;
import fitlibrary.parse.Row;
import fitlibrary.valueAdapter.ValueAdapter;
import java.util.ArrayList;
import java.util.List;

public class CombinationFixture
extends FunctionFixture {
    private List topValues = new ArrayList();
    private boolean methodOK = false;
    private MethodTarget method = null;
    private ValueAdapter firstTypeAdapter;

    public CombinationFixture() {
    }

    public CombinationFixture(Object sut) {
        super(sut);
    }

    protected void bindFirstRowToTarget(Row row) {
        ValueAdapter secondTypeAdapter = null;
        try {
            this.method = this.findMethod("combine", 2);
            Class[] argTypes = this.method.getParameterTypes();
            this.firstTypeAdapter = ValueAdapter.on((FitLibraryFixture)this, argTypes[0]);
            secondTypeAdapter = ValueAdapter.on((FitLibraryFixture)this, argTypes[1]);
        }
        catch (Exception e) {
            row.exception(this, e);
            return;
        }
        int rowLength = row.size();
        int i = 1;
        while (i < rowLength) {
            Cell cell = row.cell(i);
            try {
                this.topValues.add(secondTypeAdapter.parse(cell));
            }
            catch (Exception e) {
                cell.exception(this, e);
                return;
            }
            ++i;
        }
        this.methodOK = true;
    }

    protected void processRow(Row row) {
        if (!this.methodOK) {
            row.ignore(this.counts);
            return;
        }
        try {
            Object arg1 = this.firstTypeAdapter.parse(row.cell(0));
            if (row.size() - 1 < this.topValues.size()) {
                throw new MissingCellsFailureException("CombinationFixture");
            }
            if (row.size() - 1 > this.topValues.size()) {
                throw new ExtraCellsFailureException("CombinationFixture");
            }
            int i = 1;
            while (i < row.size()) {
                Object result = this.method.invoke(new Object[]{arg1, this.topValues.get(i - 1)});
                this.method.checkResult(row.cell((int)i).parse, result);
                ++i;
            }
        }
        catch (Exception e) {
            row.exception(this, e);
            return;
        }
    }
}

